/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;

public abstract class RecipeJsonUtils {
    private static Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    public static final String AMOUNT = "amount";
    public static final String CHANCE = "chance";
    public static final String COMMENT = "//";
    public static final String CONSTANT = "constant";
    public static final String COUNT = "count";
    public static final String DEPENDENCY = "dependency";
    public static final String ENABLE = "enable";
    public static final String ENERGY = "energy";
    public static final String ENERGY_MOD = "energy_mod";
    public static final String EXPERIENCE = "experience";
    public static final String ENTRY = "entry";
    public static final String FLUID = "fluid";
    public static final String INGREDIENT = "ingredient";
    public static final String INGREDIENTS = "ingredients";
    public static final String INPUT = "input";
    public static final String INPUTS = "inputs";
    public static final String ITEM = "item";
    public static final String LOCKED = "locked";
    public static final String MIN_CHANCE = "min_chance";
    public static final String MOD = "mod";
    public static final String NBT = "nbt";
    public static final String OUTPUT = "output";
    public static final String OUTPUTS = "outputs";
    public static final String ORE = "ore";
    public static final String PRIMARY_MOD = "primary_mod";
    public static final String REMOVE = "remove";
    public static final String RESULT = "result";
    public static final String RESULTS = "results";
    public static final String SECONDARY_MOD = "secondary_mod";
    public static final String TAG = "tag";
    public static final String TYPE = "type";
    public static final String USE_CHANCE = "use_chance";
    public static final String WILDCARD = "wildcard";
    public static final String LAVA = "lava";
    public static final String WATER = "water";
    public static final String LAVA_MOD = "lava_mod";
    public static final String WATER_MOD = "water_mod";

    private RecipeJsonUtils() {
    }

    public static boolean validityCheck(JsonObject json) {
        if (json.has(COMMENT)) {
            return false;
        }
        if (json.has(ENABLE) && !json.get(ENABLE).getAsBoolean()) {
            return false;
        }
        if (json.has(DEPENDENCY)) {
            return RecipeJsonUtils.parseDependencies(json.get(DEPENDENCY));
        }
        return true;
    }

    public static Ingredient parseIngredient(JsonElement element) {
        Ingredient ingredient;
        if (element == null || element.isJsonNull()) {
            return Ingredient.func_193369_a((ItemStack[])new ItemStack[]{ItemStack.field_190927_a});
        }
        JsonArray subElement = element.isJsonArray() ? element.getAsJsonArray() : element.getAsJsonObject();
        try {
            ingredient = Ingredient.func_199802_a((JsonElement)subElement);
            if (subElement.isJsonObject()) {
                JsonObject object = subElement.getAsJsonObject();
                int count = 1;
                if (object.has(COUNT)) {
                    count = object.get(COUNT).getAsInt();
                } else if (object.has(AMOUNT)) {
                    count = object.get(AMOUNT).getAsInt();
                }
                if (count > 1) {
                    for (ItemStack stack : ingredient.func_193365_a()) {
                        stack.func_190920_e(count);
                    }
                }
            }
        }
        catch (Throwable t) {
            ingredient = Ingredient.func_193369_a((ItemStack[])new ItemStack[]{ItemStack.field_190927_a});
        }
        return ingredient;
    }

    public static void parseInputs(List<Ingredient> ingredients, List<FluidStack> fluids, JsonElement element) {
        if (element.isJsonArray()) {
            for (JsonElement arrayElement : element.getAsJsonArray()) {
                if (arrayElement.getAsJsonObject().has(FLUID)) {
                    fluids.add(RecipeJsonUtils.parseFluidStack(arrayElement));
                    continue;
                }
                ingredients.add(RecipeJsonUtils.parseIngredient((JsonElement)arrayElement.getAsJsonObject()));
            }
        } else if (element.getAsJsonObject().has(FLUID)) {
            fluids.add(RecipeJsonUtils.parseFluidStack(element));
        } else {
            ingredients.add(RecipeJsonUtils.parseIngredient((JsonElement)element.getAsJsonObject()));
        }
    }

    public static void parseOutputs(List<ItemStack> items, List<Float> chances, List<FluidStack> fluids, JsonElement element) {
        if (element == null) {
            return;
        }
        if (element.isJsonArray()) {
            for (JsonElement arrayElement : element.getAsJsonArray()) {
                if (arrayElement.getAsJsonObject().has(FLUID)) {
                    fluids.add(RecipeJsonUtils.parseFluidStack(arrayElement));
                    continue;
                }
                ItemStack stack = RecipeJsonUtils.parseItemStack(arrayElement);
                if (stack.func_190926_b()) continue;
                items.add(stack);
                chances.add(Float.valueOf(RecipeJsonUtils.parseItemChance(arrayElement)));
            }
        } else if (element.getAsJsonObject().has(FLUID)) {
            fluids.add(RecipeJsonUtils.parseFluidStack(element));
        } else {
            ItemStack stack = RecipeJsonUtils.parseItemStack(element);
            if (!stack.func_190926_b()) {
                items.add(stack);
                chances.add(Float.valueOf(RecipeJsonUtils.parseItemChance(element)));
            }
        }
    }

    private static boolean parseDependencies(JsonElement element) {
        if (element.isJsonArray()) {
            boolean check = true;
            for (JsonElement arrayElement : element.getAsJsonArray()) {
                check &= RecipeJsonUtils.parseDependency(arrayElement);
            }
            return check;
        }
        return RecipeJsonUtils.parseDependency(element);
    }

    private static void parseItemStacks(List<ItemStack> items, JsonElement element) {
        if (element.isJsonArray()) {
            for (JsonElement arrayElement : element.getAsJsonArray()) {
                items.add(RecipeJsonUtils.parseItemStack(arrayElement));
            }
        } else {
            items.add(RecipeJsonUtils.parseItemStack(element));
        }
    }

    private static void parseItemStacks(List<ItemStack> items, List<Float> chances, JsonElement element) {
        if (element.isJsonArray()) {
            for (JsonElement arrayElement : element.getAsJsonArray()) {
                ItemStack stack = RecipeJsonUtils.parseItemStack(arrayElement);
                if (stack.func_190926_b()) continue;
                items.add(stack);
                chances.add(Float.valueOf(RecipeJsonUtils.parseItemChance(arrayElement)));
            }
        } else {
            ItemStack stack = RecipeJsonUtils.parseItemStack(element);
            if (!stack.func_190926_b()) {
                items.add(stack);
                chances.add(Float.valueOf(RecipeJsonUtils.parseItemChance(element)));
            }
        }
    }

    private static ItemStack parseItemStack(JsonElement element) {
        if (element == null || element.isJsonNull()) {
            return ItemStack.field_190927_a;
        }
        Item item = null;
        int count = 1;
        if (element.isJsonPrimitive()) {
            item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(element.getAsString()));
            return item == null ? ItemStack.field_190927_a : new ItemStack((IItemProvider)item);
        }
        JsonObject itemObject = element.getAsJsonObject();
        if (itemObject.has(COUNT)) {
            count = itemObject.get(COUNT).getAsInt();
        } else if (itemObject.has(AMOUNT)) {
            count = itemObject.get(AMOUNT).getAsInt();
        }
        if (itemObject.has(ITEM)) {
            item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(itemObject.get(ITEM).getAsString()));
        }
        if (item == null) {
            return ItemStack.field_190927_a;
        }
        ItemStack stack = new ItemStack((IItemProvider)item, count);
        if (itemObject.has(NBT)) {
            JsonElement nbtElement = itemObject.get(NBT);
            try {
                CompoundNBT nbt = element.isJsonObject() ? JsonToNBT.func_180713_a((String)GSON.toJson(nbtElement)) : JsonToNBT.func_180713_a((String)JSONUtils.func_151206_a((JsonElement)nbtElement, (String)NBT));
                stack.func_77982_d(nbt);
            }
            catch (Exception e) {
                return ItemStack.field_190927_a;
            }
        }
        return stack;
    }

    public static void parseFluidStacks(List<FluidStack> fluids, JsonElement element) {
        if (element == null) {
            return;
        }
        if (element.isJsonArray()) {
            for (JsonElement arrayElement : element.getAsJsonArray()) {
                FluidStack stack = RecipeJsonUtils.parseFluidStack(arrayElement);
                if (stack.isEmpty()) continue;
                fluids.add(stack);
            }
        } else {
            FluidStack stack = RecipeJsonUtils.parseFluidStack(element);
            if (!stack.isEmpty()) {
                fluids.add(stack);
            }
        }
    }

    private static FluidStack parseFluidStack(JsonElement element) {
        if (element == null || element.isJsonNull()) {
            return FluidStack.EMPTY;
        }
        Fluid fluid = null;
        int amount = 1000;
        if (element.isJsonPrimitive()) {
            fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(element.getAsString()));
            return fluid == null ? FluidStack.EMPTY : new FluidStack(fluid, amount);
        }
        JsonObject fluidObject = element.getAsJsonObject();
        if (fluidObject.has(AMOUNT)) {
            amount = fluidObject.get(AMOUNT).getAsInt();
        } else if (fluidObject.has(COUNT)) {
            amount = fluidObject.get(COUNT).getAsInt();
        }
        if (fluidObject.has(FLUID)) {
            fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(fluidObject.get(FLUID).getAsString()));
        }
        if (fluid == null) {
            return FluidStack.EMPTY;
        }
        FluidStack stack = new FluidStack(fluid, amount);
        if (fluidObject.has(NBT)) {
            try {
                stack.setTag(JsonToNBT.func_180713_a((String)fluidObject.get(NBT).getAsString()));
            }
            catch (Exception e) {
                return FluidStack.EMPTY;
            }
        }
        return stack;
    }

    private static float parseItemChance(JsonElement element) {
        JsonObject json = element.getAsJsonObject();
        if (json.has(CHANCE)) {
            float chance = json.get(CHANCE).getAsFloat();
            if (chance > 0.0f && json.has(LOCKED) && json.get(LOCKED).getAsBoolean()) {
                chance *= -1.0f;
            }
            return chance;
        }
        return -1.0f;
    }

    private static boolean parseDependency(JsonElement element) {
        JsonObject json = element.getAsJsonObject();
        if (json.has(MOD)) {
            return ModList.get().isLoaded(json.get(MOD).getAsString());
        }
        return true;
    }
}

