/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.util;

import java.util.HashMap;
import java.util.Objects;
import java.util.function.Predicate;

public class DefaultedHashMap<K, V>
extends HashMap<K, V> {
    private V defaultValue;
    private Predicate<V> useDefaultPredicate;

    public DefaultedHashMap(V defaultValue) {
        this(defaultValue, Objects::isNull);
    }

    public DefaultedHashMap(V defaultValue, Predicate<V> useDefaultPredicate) {
        this.defaultValue = defaultValue;
        this.useDefaultPredicate = useDefaultPredicate;
    }

    @Override
    public V get(Object key) {
        Object value = super.get(key);
        return this.useDefaultPredicate.test(value) ? this.defaultValue : value;
    }
}

