/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.inventory;

import cofh.lib.inventory.ItemStorageCoFH;
import cofh.lib.inventory.SimpleItemHandler;
import cofh.lib.tileentity.ITileCallback;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;

public class ManagedItemHandler
extends SimpleItemHandler {
    protected List<ItemStorageCoFH> inputSlots;
    protected List<ItemStorageCoFH> outputSlots;

    public ManagedItemHandler(@Nullable ITileCallback tile, @Nonnull List<ItemStorageCoFH> inputSlots, @Nonnull List<ItemStorageCoFH> outputSlots) {
        super(tile);
        this.inputSlots = inputSlots;
        this.outputSlots = outputSlots;
        this.slots.addAll(inputSlots);
        this.slots.addAll(outputSlots);
    }

    @Override
    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        if (slot < 0 || slot >= this.inputSlots.size()) {
            return stack;
        }
        ItemStack ret = ((ItemStorageCoFH)this.slots.get(slot)).insertItem(slot, stack, simulate);
        if (this.tile != null && !simulate) {
            this.tile.onInventoryChange(slot);
        }
        return ret;
    }
}

