/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.fluid;

import cofh.lib.fluid.FluidStorageCoFH;
import cofh.lib.fluid.SimpleFluidHandler;
import cofh.lib.tileentity.ITileCallback;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraftforge.fluids.FluidStack;

public class SimpleTankInv
extends SimpleFluidHandler {
    protected String tag;

    public SimpleTankInv(@Nullable ITileCallback tile) {
        this(tile, 0, "TankInv");
    }

    public SimpleTankInv(@Nullable ITileCallback tile, int size) {
        this(tile, size, "TankInv");
    }

    public SimpleTankInv(@Nullable ITileCallback tile, @Nonnull List<FluidStorageCoFH> tanks) {
        this(tile, tanks, "TankInv");
    }

    public SimpleTankInv(@Nullable ITileCallback tile, @Nonnull String tag) {
        this(tile, 0, tag);
    }

    public SimpleTankInv(@Nullable ITileCallback tile, @Nonnull List<FluidStorageCoFH> tanks, @Nonnull String tag) {
        super(tile, tanks);
        this.tag = tag;
    }

    public SimpleTankInv(@Nullable ITileCallback tile, int size, @Nonnull String tag) {
        super(tile, new ArrayList<FluidStorageCoFH>(size));
        this.tile = tile;
        this.tag = tag;
        for (int i = 0; i < size; ++i) {
            this.tanks.add(new FluidStorageCoFH());
        }
    }

    public void clear() {
        for (FluidStorageCoFH tank : this.tanks) {
            tank.setFluidStack(FluidStack.EMPTY);
        }
    }

    public void set(int tank, FluidStack stack) {
        ((FluidStorageCoFH)this.tanks.get(tank)).setFluidStack(stack);
    }

    public FluidStack get(int tank) {
        return ((FluidStorageCoFH)this.tanks.get(tank)).getFluidStack();
    }

    public FluidStorageCoFH getTank(int tank) {
        return (FluidStorageCoFH)this.tanks.get(tank);
    }

    public SimpleTankInv readFromNBT(CompoundNBT nbt) {
        for (FluidStorageCoFH tank : this.tanks) {
            tank.setFluidStack(FluidStack.EMPTY);
        }
        ListNBT list = nbt.func_150295_c(this.tag, 10);
        for (int i = 0; i < list.size(); ++i) {
            CompoundNBT tag = list.func_150305_b(i);
            byte tank = tag.func_74771_c("Tank");
            if (tank < 0 || tank >= this.tanks.size()) continue;
            ((FluidStorageCoFH)this.tanks.get(tank)).readFromNBT(tag);
        }
        return this;
    }

    public CompoundNBT writeToNBT(CompoundNBT nbt) {
        if (this.tanks.size() <= 0) {
            return nbt;
        }
        ListNBT list = new ListNBT();
        for (int i = 0; i < this.tanks.size(); ++i) {
            if (((FluidStorageCoFH)this.tanks.get(i)).isEmpty()) continue;
            CompoundNBT tag = new CompoundNBT();
            tag.func_74774_a("Tank", (byte)i);
            ((FluidStorageCoFH)this.tanks.get(i)).writeToNBT(tag);
            list.add((Object)tag);
        }
        if (!list.isEmpty()) {
            nbt.func_218657_a(this.tag, (INBT)list);
        }
        return nbt;
    }
}

