/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.fluid;

import cofh.lib.fluid.FluidStorageCoFH;
import cofh.lib.fluid.ManagedFluidHandler;
import cofh.lib.fluid.SimpleFluidHandler;
import cofh.lib.fluid.SimpleTankInv;
import cofh.lib.tileentity.ITileCallback;
import cofh.lib.util.StorageGroup;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.EmptyFluidHandler;

public class ManagedTankInv
extends SimpleTankInv {
    protected List<FluidStorageCoFH> inputTanks = new ArrayList<FluidStorageCoFH>();
    protected List<FluidStorageCoFH> outputTanks = new ArrayList<FluidStorageCoFH>();
    protected List<FluidStorageCoFH> accessibleTanks = new ArrayList<FluidStorageCoFH>();
    protected List<FluidStorageCoFH> internalTanks = new ArrayList<FluidStorageCoFH>();

    public ManagedTankInv(ITileCallback tile) {
        super(tile);
    }

    public ManagedTankInv(ITileCallback tile, String tag) {
        super(tile, tag);
    }

    public void addTank(FluidStorageCoFH tank, StorageGroup group) {
        this.tanks.add(tank);
        switch (group) {
            case INPUT: {
                this.inputTanks.add(tank);
                this.accessibleTanks.add(tank);
                break;
            }
            case OUTPUT: {
                this.outputTanks.add(tank);
                this.accessibleTanks.add(tank);
                break;
            }
            case ACCESSIBLE: {
                this.accessibleTanks.add(tank);
                break;
            }
            case INTERNAL: {
                this.internalTanks.add(tank);
                break;
            }
        }
    }

    public List<FluidStorageCoFH> getInputTanks() {
        return this.inputTanks;
    }

    public List<FluidStorageCoFH> getOutputTanks() {
        return this.outputTanks;
    }

    public List<FluidStorageCoFH> getInternalTanks() {
        return this.internalTanks;
    }

    public IFluidHandler getHandler(StorageGroup group) {
        switch (group) {
            case INPUT: {
                return new ManagedFluidHandler(this.tile, this.inputTanks, Collections.emptyList());
            }
            case OUTPUT: {
                return new ManagedFluidHandler(this.tile, Collections.emptyList(), this.outputTanks);
            }
            case ACCESSIBLE: {
                return new ManagedFluidHandler(this.tile, this.inputTanks, this.outputTanks);
            }
            case INTERNAL: {
                return new SimpleFluidHandler(this.tile, this.internalTanks);
            }
            case ALL: {
                return new SimpleFluidHandler(this.tile, this.tanks);
            }
        }
        return EmptyFluidHandler.INSTANCE;
    }
}

