/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.fluid;

import cofh.lib.util.helpers.MathHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public interface IFluidContainerItem {
    default public int getSpace(ItemStack container) {
        return this.getCapacity(container) - this.getFluidAmount(container);
    }

    default public int getScaledFluidStored(ItemStack container, int scale) {
        return MathHelper.round((double)this.getFluidAmount(container) * (double)scale / (double)this.getCapacity(container));
    }

    default public int getFluidAmount(ItemStack container) {
        return this.getFluid(container).getAmount();
    }

    default public FluidStack getFluid(ItemStack container) {
        if (container.func_77978_p() == null) {
            container.func_77982_d(new CompoundNBT());
        }
        if (!container.func_77978_p().func_74764_b("Fluid")) {
            return FluidStack.EMPTY;
        }
        return FluidStack.loadFluidStackFromNBT((CompoundNBT)container.func_77978_p().func_74775_l("Fluid"));
    }

    public boolean isFluidValid(ItemStack var1, FluidStack var2);

    public int getCapacity(ItemStack var1);

    public int fill(ItemStack var1, FluidStack var2, IFluidHandler.FluidAction var3);

    public FluidStack drain(ItemStack var1, int var2, IFluidHandler.FluidAction var3);
}

