/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.network.packet.client;

import cofh.core.CoFHCore;
import cofh.lib.network.packet.IPacketClient;
import cofh.lib.network.packet.PacketBase;
import cofh.lib.util.helpers.StringHelper;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.ITextComponent;

public class IndexedChatPacket
extends PacketBase
implements IPacketClient {
    protected int index;
    protected String message;

    public IndexedChatPacket() {
        super(12, CoFHCore.PACKET_HANDLER);
    }

    @Override
    public void handleClient() {
        CoFHCore.proxy.addIndexedChatMessage(StringHelper.fromJSON(this.message), this.index);
    }

    @Override
    public void write(PacketBuffer buf) {
        buf.writeInt(this.index);
        buf.func_180714_a(this.message);
    }

    @Override
    public void read(PacketBuffer buf) {
        this.index = buf.readInt();
        this.message = buf.func_150789_c(Short.MAX_VALUE);
    }

    public static void sendToClient(ITextComponent chat, int index, ServerPlayerEntity player) {
        IndexedChatPacket packet = new IndexedChatPacket();
        packet.index = index;
        packet.message = StringHelper.toJSON(chat);
        packet.sendToPlayer(player);
    }
}

