/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.event;

import cofh.core.init.CoreConfig;
import cofh.lib.util.helpers.StringHelper;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class CoreClientEvents {
    private static boolean registered = false;

    public static void register() {
        if (registered) {
            return;
        }
        MinecraftForge.EVENT_BUS.register(CoreClientEvents.class);
        registered = true;
    }

    private CoreClientEvents() {
    }

    @SubscribeEvent
    public static void handleItemTooltipEvent(ItemTooltipEvent event) {
        String infoKey;
        ItemStack stack = event.getItemStack();
        if (CoreConfig.enableItemDescriptions && StringHelper.canLocalize(infoKey = stack.func_77973_b().func_77667_c(stack) + ".desc")) {
            event.getToolTip().add(StringHelper.getInfoTextComponent(infoKey));
        }
        if (CoreConfig.enableEnchantmentDescriptions) {
            String enchKey;
            Enchantment ench;
            if (stack.func_77978_p() == null) {
                return;
            }
            ListNBT list = stack.func_77978_p().func_150295_c("StoredEnchantments", 10);
            if (list.size() == 1 && (ench = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(ResourceLocation.func_208304_a((String)list.func_150305_b(0).func_74779_i("id")))) != null && ench.getRegistryName() != null && StringHelper.canLocalize(enchKey = ench.func_77320_a() + ".desc")) {
                event.getToolTip().add(StringHelper.getInfoTextComponent(enchKey));
            }
        }
    }
}

