/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.client.gui.element;

import cofh.core.client.gui.IGuiAccess;
import cofh.core.client.gui.element.ElementBase;
import cofh.lib.util.IResourceStorage;
import cofh.lib.util.helpers.MathHelper;
import cofh.lib.util.helpers.RenderHelper;
import cofh.lib.util.helpers.StringHelper;
import java.util.List;
import java.util.function.BooleanSupplier;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public abstract class ElementResourceStorage
extends ElementBase {
    protected ResourceLocation underlayTexture;
    protected ResourceLocation overlayTexture;
    protected IResourceStorage storage;
    protected boolean infinite;
    protected int minDisplay;
    protected BooleanSupplier drawUnderlay = TRUE;
    protected BooleanSupplier drawOverlay = TRUE;

    public ElementResourceStorage(IGuiAccess gui, int posX, int posY, IResourceStorage storage) {
        super(gui, posX, posY);
        this.storage = storage;
    }

    public final ElementResourceStorage setUnderlayTexture(String texture) {
        return this.setUnderlayTexture(texture, TRUE);
    }

    public final ElementResourceStorage setUnderlayTexture(String texture, BooleanSupplier draw) {
        this.underlayTexture = new ResourceLocation(texture);
        this.drawUnderlay = draw;
        return this;
    }

    public final ElementResourceStorage setOverlayTexture(String texture) {
        return this.setOverlayTexture(texture, TRUE);
    }

    public final ElementResourceStorage setOverlayTexture(String texture, BooleanSupplier draw) {
        this.overlayTexture = new ResourceLocation(texture);
        this.drawOverlay = draw;
        return this;
    }

    public ElementResourceStorage setInfinite(boolean infinite) {
        this.infinite = infinite;
        return this;
    }

    public ElementResourceStorage setMinDisplay(int minDisplay) {
        this.minDisplay = minDisplay;
        return this;
    }

    @Override
    public void drawBackground(int mouseX, int mouseY) {
        this.drawStorage();
        this.drawUnderlayTexture();
        this.drawResource();
        this.drawOverlayTexture();
    }

    @Override
    public void addTooltip(List<ITextComponent> tooltipList, int mouseX, int mouseY) {
        if (this.infinite) {
            tooltipList.add((ITextComponent)new TranslationTextComponent("info.cofh.infinite", new Object[0]));
        } else {
            tooltipList.add((ITextComponent)new StringTextComponent(StringHelper.format(this.storage.getStored()) + " / " + StringHelper.format(this.storage.getCapacity()) + " " + this.storage.getUnit()));
        }
    }

    protected int getScaled(int scale) {
        if (this.storage.getCapacity() <= 0 || this.infinite) {
            return scale;
        }
        double fraction = (double)this.storage.getStored() * (double)scale / (double)this.storage.getCapacity();
        return this.minDisplay > 0 && this.storage.getStored() > 0 ? Math.max(this.minDisplay, MathHelper.round(fraction)) : MathHelper.round(fraction);
    }

    protected void drawStorage() {
        RenderHelper.bindTexture(this.texture);
        this.drawTexturedModalRect(this.posX, this.posY, 0, 0, this.width, this.height);
    }

    protected void drawUnderlayTexture() {
        if (this.drawUnderlay.getAsBoolean() && this.underlayTexture != null) {
            RenderHelper.bindTexture(this.underlayTexture);
            this.drawTexturedModalRect(this.posX, this.posY, 0, 0, this.width, this.height);
        }
    }

    protected abstract void drawResource();

    protected void drawOverlayTexture() {
        if (this.drawOverlay.getAsBoolean() && this.overlayTexture != null) {
            RenderHelper.bindTexture(this.overlayTexture);
            this.drawTexturedModalRect(this.posX, this.posY, 0, 0, this.width, this.height);
        }
    }
}

