/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.client.gui.element;

import cofh.core.client.gui.IGuiAccess;
import cofh.core.client.gui.element.ElementButtonBase;
import cofh.lib.util.helpers.RenderHelper;
import java.util.List;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class ElementButton
extends ElementButtonBase {
    private int sheetX;
    private int sheetY;
    private int hoverX;
    private int hoverY;
    private int disabledX = 0;
    private int disabledY = 0;
    private boolean managedClicks;
    private String tooltip;

    public ElementButton(IGuiAccess gui, int posX, int posY, int sizeX, int sizeY, int sheetX, int sheetY, int hoverX, int hoverY, String texture) {
        super(gui, posX, posY, sizeX, sizeY);
        this.setGuiManagedClicks(false);
        this.setTexture(texture, this.texW, this.texH);
        this.sheetX = sheetX;
        this.sheetY = sheetY;
        this.hoverX = hoverX;
        this.hoverY = hoverY;
    }

    public ElementButton(IGuiAccess gui, int posX, int posY, int sizeX, int sizeY, int sheetX, int sheetY, int hoverX, int hoverY, int disabledX, int disabledY, String texture) {
        this(gui, posX, posY, sizeX, sizeY, sheetX, sheetY, hoverX, hoverY, texture);
        this.disabledX = disabledX;
        this.disabledY = disabledY;
    }

    public ElementButton(IGuiAccess gui, int posX, int posY, String name, int sheetX, int sheetY, int hoverX, int hoverY, int sizeX, int sizeY, String texture) {
        super(gui, posX, posY, sizeX, sizeY);
        this.setGuiManagedClicks(true);
        this.setTexture(texture, this.texW, this.texH);
        this.setName(name);
        this.sheetX = sheetX;
        this.sheetY = sheetY;
        this.hoverX = hoverX;
        this.hoverY = hoverY;
    }

    public ElementButton(IGuiAccess gui, int posX, int posY, String name, int sheetX, int sheetY, int hoverX, int hoverY, int disabledX, int disabledY, int sizeX, int sizeY, String texture) {
        this(gui, posX, posY, name, sheetX, sheetY, hoverX, hoverY, sizeX, sizeY, texture);
        this.disabledX = disabledX;
        this.disabledY = disabledY;
    }

    public ElementButton setGuiManagedClicks(boolean managed) {
        this.managedClicks = managed;
        return this;
    }

    public ElementButton clearToolTip() {
        this.tooltip = null;
        return this;
    }

    public ElementButton setToolTip(String tooltip) {
        this.tooltip = tooltip;
        return this;
    }

    @Override
    public void drawBackground(int mouseX, int mouseY) {
        RenderHelper.resetColor();
        RenderHelper.bindTexture(this.texture);
        if (this.enabled()) {
            if (this.intersectsWith(mouseX, mouseY)) {
                this.drawTexturedModalRect(this.posX, this.posY, this.hoverX, this.hoverY, this.width, this.height);
            } else {
                this.drawTexturedModalRect(this.posX, this.posY, this.sheetX, this.sheetY, this.width, this.height);
            }
        } else {
            this.drawTexturedModalRect(this.posX, this.posY, this.disabledX, this.disabledY, this.width, this.height);
        }
    }

    @Override
    public void addTooltip(List<ITextComponent> tooltipList, int mouseX, int mouseY) {
        if (this.tooltip != null) {
            tooltipList.add((ITextComponent)new TranslationTextComponent(this.tooltip, new Object[0]));
        }
    }

    @Override
    public boolean mouseClicked(double x, double y, int mouseButton) {
        if (!this.managedClicks) {
            return super.mouseClicked(x, y, mouseButton);
        }
        if (this.enabled()) {
            this.gui.handleElementButtonClick(this.name(), mouseButton);
            return true;
        }
        return false;
    }

    public void setSheetX(int pos) {
        this.sheetX = pos;
    }

    public void setSheetY(int pos) {
        this.sheetY = pos;
    }

    public void setHoverX(int pos) {
        this.hoverX = pos;
    }

    public void setHoverY(int pos) {
        this.hoverY = pos;
    }

    public void setActive() {
        this.setEnabled(true);
    }

    public void setDisabled() {
        this.setEnabled(false);
    }
}

