/*
 * Decompiled with CFR 0.152.
 */
package com.williambl.bigbuckets;

import com.williambl.bigbuckets.BigBucketFluidHandler;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.BlockState;
import net.minecraft.block.IBucketPickupHandler;
import net.minecraft.block.ILiquidContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.FlowingFluid;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.stats.Stats;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.registries.ForgeRegistries;

public class BigBucketItem
extends Item {
    public BigBucketItem(Item.Properties builder) {
        super(builder);
    }

    protected ItemStack emptyBucket(ItemStack stack, PlayerEntity player) {
        this.drain(stack, 1000);
        return stack;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack stack;
        RayTraceResult raytraceresult = BigBucketItem.func_219968_a((World)worldIn, (PlayerEntity)playerIn, (RayTraceContext.FluidMode)(this.getFullness(stack = playerIn.func_184586_b(handIn)) == this.getCapacity(stack) ? RayTraceContext.FluidMode.NONE : RayTraceContext.FluidMode.SOURCE_ONLY));
        ActionResult ret = ForgeEventFactory.onBucketUse((PlayerEntity)playerIn, (World)worldIn, (ItemStack)stack, (RayTraceResult)raytraceresult);
        if (ret != null) {
            return ret;
        }
        if (raytraceresult.func_216346_c() == RayTraceResult.Type.MISS) {
            return new ActionResult(ActionResultType.PASS, (Object)stack);
        }
        if (raytraceresult.func_216346_c() != RayTraceResult.Type.BLOCK) {
            return new ActionResult(ActionResultType.PASS, (Object)stack);
        }
        BlockRayTraceResult blockraytraceresult = (BlockRayTraceResult)raytraceresult;
        BlockPos blockpos = blockraytraceresult.func_216350_a();
        if (worldIn.func_175660_a(playerIn, blockpos) && playerIn.func_175151_a(blockpos, blockraytraceresult.func_216354_b(), stack)) {
            BlockPos blockpos1;
            Fluid fluid;
            BlockState blockstate1;
            if (this.getFullness(stack) != this.getCapacity(stack) && (blockstate1 = worldIn.func_180495_p(blockpos)).func_177230_c() instanceof IBucketPickupHandler && (fluid = ((IBucketPickupHandler)blockstate1.func_177230_c()).func_204508_a((IWorld)worldIn, blockpos, blockstate1)) != Fluids.field_204541_a && this.canAcceptFluid(stack, fluid, 1000)) {
                playerIn.func_71029_a(Stats.field_75929_E.func_199076_b((Object)this));
                SoundEvent soundevent = this.getFluid(stack).getAttributes().getEmptySound();
                if (soundevent == null) {
                    soundevent = fluid.func_207185_a(FluidTags.field_206960_b) ? SoundEvents.field_187633_N : SoundEvents.field_187630_M;
                }
                playerIn.func_184185_a(soundevent, 1.0f, 1.0f);
                ItemStack itemstack1 = this.fillBucket(stack, playerIn, fluid);
                if (!worldIn.field_72995_K) {
                    CriteriaTriggers.field_204813_j.func_204817_a((ServerPlayerEntity)playerIn, new ItemStack((IItemProvider)fluid.func_204524_b()));
                }
                return new ActionResult(ActionResultType.SUCCESS, (Object)itemstack1);
            }
            BlockState blockstate = worldIn.func_180495_p(blockpos);
            BlockPos blockPos = blockpos1 = blockstate.func_177230_c() instanceof ILiquidContainer && this.getFluid(stack) == Fluids.field_204546_a ? blockpos : blockraytraceresult.func_216350_a().func_177972_a(blockraytraceresult.func_216354_b());
            if (this.tryPlaceContainedLiquid(playerIn, worldIn, blockpos1, blockraytraceresult, stack)) {
                this.onLiquidPlaced(worldIn, stack, blockpos1);
                if (playerIn instanceof ServerPlayerEntity) {
                    CriteriaTriggers.field_193137_x.func_193173_a((ServerPlayerEntity)playerIn, blockpos1, stack);
                }
                playerIn.func_71029_a(Stats.field_75929_E.func_199076_b((Object)this));
                return new ActionResult(ActionResultType.SUCCESS, (Object)this.emptyBucket(stack, playerIn));
            }
            return new ActionResult(ActionResultType.FAIL, (Object)stack);
        }
        return new ActionResult(ActionResultType.FAIL, (Object)stack);
    }

    public void onLiquidPlaced(World worldIn, ItemStack p_203792_2_, BlockPos pos) {
    }

    private ItemStack fillBucket(ItemStack stack, PlayerEntity player, Fluid fluid) {
        this.fill(stack, new FluidStack(fluid, 1000));
        return stack;
    }

    public boolean tryPlaceContainedLiquid(@Nullable PlayerEntity player, World worldIn, BlockPos posIn, @Nullable BlockRayTraceResult raytrace, ItemStack stack) {
        if (!(this.getFluid(stack) instanceof FlowingFluid)) {
            return false;
        }
        BlockState blockstate = worldIn.func_180495_p(posIn);
        Material material = blockstate.func_185904_a();
        boolean flag = !material.func_76220_a();
        boolean flag1 = material.func_76222_j();
        if (worldIn.func_175623_d(posIn) || flag || flag1 || blockstate.func_177230_c() instanceof ILiquidContainer && ((ILiquidContainer)blockstate.func_177230_c()).func_204510_a((IBlockReader)worldIn, posIn, blockstate, this.getFluid(stack))) {
            if (worldIn.field_73011_w.func_177500_n() && this.getFluid(stack).func_207185_a(FluidTags.field_206959_a)) {
                int i = posIn.func_177958_n();
                int j = posIn.func_177956_o();
                int k = posIn.func_177952_p();
                worldIn.func_184133_a(player, posIn, SoundEvents.field_187646_bt, SoundCategory.BLOCKS, 0.5f, 2.6f + (worldIn.field_73012_v.nextFloat() - worldIn.field_73012_v.nextFloat()) * 0.8f);
                for (int l = 0; l < 8; ++l) {
                    worldIn.func_195594_a((IParticleData)ParticleTypes.field_197594_E, (double)i + Math.random(), (double)j + Math.random(), (double)k + Math.random(), 0.0, 0.0, 0.0);
                }
            } else if (blockstate.func_177230_c() instanceof ILiquidContainer && this.getFluid(stack) == Fluids.field_204546_a) {
                if (((ILiquidContainer)blockstate.func_177230_c()).func_204509_a((IWorld)worldIn, posIn, blockstate, ((FlowingFluid)this.getFluid(stack)).func_207204_a(false))) {
                    this.playEmptySound(player, (IWorld)worldIn, posIn, stack);
                }
            } else {
                if (!worldIn.field_72995_K && (flag || flag1) && !material.func_76224_d()) {
                    worldIn.func_175655_b(posIn, true);
                }
                this.playEmptySound(player, (IWorld)worldIn, posIn, stack);
                worldIn.func_180501_a(posIn, this.getFluid(stack).func_207188_f().func_206883_i(), 11);
            }
            return true;
        }
        return raytrace != null && this.tryPlaceContainedLiquid(player, worldIn, raytrace.func_216350_a().func_177972_a(raytrace.func_216354_b()), null, stack);
    }

    protected void playEmptySound(@Nullable PlayerEntity player, IWorld worldIn, BlockPos pos, ItemStack stack) {
        SoundEvent soundevent = this.getFluid(stack).getAttributes().getEmptySound();
        if (soundevent == null) {
            soundevent = this.getFluid(stack).func_207185_a(FluidTags.field_206960_b) ? SoundEvents.field_187627_L : SoundEvents.field_187624_K;
        }
        worldIn.func_184133_a(player, pos, soundevent, SoundCategory.BLOCKS, 1.0f, 1.0f);
    }

    @Nullable
    public ICapabilityProvider initCapabilities(final ItemStack stack, @Nullable CompoundNBT nbt) {
        return new ICapabilityProvider(){

            @Nonnull
            public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
                return cap == CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY ? LazyOptional.of(() -> new BigBucketFluidHandler(stack)) : LazyOptional.empty();
            }
        };
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        tooltip.add((ITextComponent)new TranslationTextComponent("item.bigbuckets.bigbucket.desc.fluid", new Object[]{this.getFluid(stack).func_207188_f().func_206883_i().func_177230_c().func_200291_n()}));
        tooltip.add((ITextComponent)new TranslationTextComponent("item.bigbuckets.bigbucket.desc.capacity", new Object[]{Float.valueOf((float)this.getCapacity(stack) / 1000.0f)}));
        tooltip.add((ITextComponent)new TranslationTextComponent("item.bigbuckets.bigbucket.desc.fullness", new Object[]{Float.valueOf((float)this.getFullness(stack) / 1000.0f)}));
    }

    public ITextComponent func_200295_i(ItemStack stack) {
        if (this.getFluid(stack) == Fluids.field_204541_a) {
            return super.func_200295_i(stack);
        }
        return super.func_200295_i(stack).func_150257_a(new StringTextComponent(" (").func_150257_a(this.getFluid(stack).func_207188_f().func_206883_i().func_177230_c().func_200291_n()).func_150257_a((ITextComponent)new StringTextComponent(")")));
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return this.getCapacity(stack) > 0;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        double capacity;
        double fullness = this.getFullness(stack);
        return fullness == (capacity = (double)this.getCapacity(stack)) ? 0.0 : (capacity - fullness) / capacity;
    }

    public void func_150895_a(ItemGroup itemGroup, NonNullList<ItemStack> itemStacks) {
        if (this.func_194125_a(itemGroup)) {
            ItemStack stack = new ItemStack((IItemProvider)this);
            this.setCapacity(stack, 16000);
            itemStacks.add((Object)stack);
        }
    }

    public Fluid getFluid(ItemStack stack) {
        LazyOptional cap = stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY);
        if (cap.isPresent()) {
            BigBucketFluidHandler fluidHandler = (BigBucketFluidHandler)((Object)cap.orElseThrow(NullPointerException::new));
            if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("BigBuckets")) {
                CompoundNBT tag = stack.func_179543_a("BigBuckets");
                this.fixNBT(tag, fluidHandler, stack);
            }
            return fluidHandler.getFluid().getFluid();
        }
        return Fluids.field_204541_a;
    }

    public int getCapacity(ItemStack stack) {
        LazyOptional cap = stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY);
        if (cap.isPresent()) {
            BigBucketFluidHandler fluidHandler = (BigBucketFluidHandler)((Object)cap.orElseThrow(NullPointerException::new));
            if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("BigBuckets")) {
                CompoundNBT tag = stack.func_179543_a("BigBuckets");
                this.fixNBT(tag, fluidHandler, stack);
            }
            return fluidHandler.getTankCapacity(0);
        }
        return 0;
    }

    public int getFullness(ItemStack stack) {
        LazyOptional cap = stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY);
        if (cap.isPresent()) {
            BigBucketFluidHandler fluidHandler = (BigBucketFluidHandler)((Object)cap.orElseThrow(NullPointerException::new));
            if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("BigBuckets")) {
                CompoundNBT tag = stack.func_179543_a("BigBuckets");
                this.fixNBT(tag, fluidHandler, stack);
            }
            return fluidHandler.getFluid().getAmount();
        }
        return 0;
    }

    public void setCapacity(ItemStack stack, int capacity) {
        LazyOptional cap = stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY);
        if (cap.isPresent()) {
            BigBucketFluidHandler fluidHandler = (BigBucketFluidHandler)((Object)cap.orElseThrow(NullPointerException::new));
            fluidHandler.setTankCapacity(capacity);
        }
    }

    public void fill(ItemStack stack, FluidStack fluidStack) {
        LazyOptional cap = stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY);
        if (cap.isPresent()) {
            BigBucketFluidHandler fluidHandler = (BigBucketFluidHandler)((Object)cap.orElseThrow(NullPointerException::new));
            fluidHandler.fill(fluidStack, IFluidHandler.FluidAction.EXECUTE);
        }
    }

    public void drain(ItemStack stack, int drainAmount) {
        LazyOptional cap = stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY);
        if (cap.isPresent()) {
            BigBucketFluidHandler fluidHandler = (BigBucketFluidHandler)((Object)cap.orElseThrow(NullPointerException::new));
            fluidHandler.drain(drainAmount, IFluidHandler.FluidAction.EXECUTE);
        }
    }

    public boolean canAcceptFluid(ItemStack stack, Fluid fluid, int amount) {
        return this.getFullness(stack) + amount <= this.getCapacity(stack) && (this.getFluid(stack) == fluid || this.getFluid(stack) == Fluids.field_204541_a);
    }

    private void fixNBT(CompoundNBT tag, BigBucketFluidHandler fluidHandler, ItemStack stack) {
        Fluid oldFluid = (Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(tag.func_74779_i("Fluid")));
        int oldCapacity = tag.func_74762_e("Capacity");
        int oldFullness = tag.func_74762_e("Fullness");
        fluidHandler.setTankCapacity(oldCapacity * 1000);
        if (oldFluid == null) {
            stack.func_196083_e("BigBuckets");
            return;
        }
        FluidStack fluidStack = new FluidStack(oldFluid, oldFullness);
        fluidHandler.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.EXECUTE);
        fluidHandler.fill(fluidStack, IFluidHandler.FluidAction.EXECUTE);
        stack.func_196083_e("BigBuckets");
    }
}

