/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.curios.common;

import java.util.stream.Stream;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraftforge.fml.InterModComms;
import top.theillusivec4.curios.api.CurioType;
import top.theillusivec4.curios.api.CuriosAPI;
import top.theillusivec4.curios.api.imc.CurioIMCMessage;

public class CuriosIMC {
    public static void processCurioTypes(Stream<InterModComms.IMCMessage> register, Stream<InterModComms.IMCMessage> modify, Stream<InterModComms.IMCMessage> icons) {
        register.filter(msg -> msg.getMessageSupplier().get() instanceof CurioIMCMessage).map(msg -> (CurioIMCMessage)msg.getMessageSupplier().get()).forEach(msg -> CuriosIMC.processType(msg, true));
        modify.filter(msg -> msg.getMessageSupplier().get() instanceof CurioIMCMessage).map(msg -> (CurioIMCMessage)msg.getMessageSupplier().get()).forEach(msg -> CuriosIMC.processType(msg, false));
        icons.filter(msg -> {
            Object obj = msg.getMessageSupplier().get();
            if (obj instanceof Tuple) {
                Tuple tup = (Tuple)obj;
                return tup.func_76341_a() instanceof String && tup.func_76340_b() instanceof ResourceLocation;
            }
            return false;
        }).map(msg -> (Tuple)msg.getMessageSupplier().get()).forEach(msg -> CuriosAPI.idToIcon.put((String)msg.func_76341_a(), (ResourceLocation)msg.func_76340_b()));
    }

    private static void processType(CurioIMCMessage message, boolean create) {
        String identifier = message.getIdentifier();
        if (CuriosAPI.idToType.containsKey(identifier)) {
            CurioType presentType = CuriosAPI.idToType.get(identifier);
            if (message.getSize() > presentType.getSize()) {
                presentType.defaultSize(message.getSize());
            }
            if (!message.isEnabled() && presentType.isEnabled()) {
                presentType.enabled(false);
            }
            if (message.isHidden() && !presentType.isHidden()) {
                presentType.hide(true);
            }
        } else if (create) {
            CuriosAPI.idToType.put(identifier, new CurioType(identifier).defaultSize(message.getSize()).enabled(message.isEnabled()).hide(message.isHidden()));
        }
    }
}

