/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.curios.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import javax.annotation.Nonnull;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.recipebook.IRecipeShownListener;
import net.minecraft.client.gui.recipebook.RecipeBookGui;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.screen.inventory.InventoryScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.ImageButton;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.InputMappings;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.RecipeBookContainer;
import net.minecraft.inventory.container.Slot;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import top.theillusivec4.curios.api.CuriosAPI;
import top.theillusivec4.curios.api.capability.ICurioItemHandler;
import top.theillusivec4.curios.api.inventory.SlotCurio;
import top.theillusivec4.curios.client.KeyRegistry;
import top.theillusivec4.curios.client.gui.GuiButtonCurios;
import top.theillusivec4.curios.common.CuriosConfig;
import top.theillusivec4.curios.common.inventory.CuriosContainer;

public class CuriosScreen
extends ContainerScreen<CuriosContainer>
implements IRecipeShownListener {
    static final ResourceLocation CURIO_INVENTORY = new ResourceLocation("curios", "textures/gui/inventory.png");
    static final ResourceLocation RECIPE_BUTTON_TEXTURE = new ResourceLocation("minecraft:textures/gui/recipe_button.png");
    private static final ResourceLocation CREATIVE_INVENTORY_TABS = new ResourceLocation("textures/gui/container/creative_inventory/tabs.png");
    private final RecipeBookGui recipeBookGui = new RecipeBookGui();
    public boolean hasScrollBar;
    public boolean widthTooNarrow;
    private GuiButtonCurios buttonCurios;
    private float currentScroll;
    private boolean isScrolling;
    private boolean buttonClicked;

    public CuriosScreen(CuriosContainer curiosContainer, PlayerInventory playerInventory, ITextComponent title) {
        super((Container)curiosContainer, playerInventory, title);
        this.passEvents = true;
    }

    public void init() {
        super.init();
        if (this.minecraft != null) {
            if (this.minecraft.field_71439_g != null) {
                this.hasScrollBar = (Boolean)CuriosAPI.getCuriosHandler((LivingEntity)this.minecraft.field_71439_g).map(handler -> handler.getSlots() > 8).orElse((Object)false);
            }
            this.widthTooNarrow = this.width < (this.hasScrollBar ? 461 : 491);
            this.recipeBookGui.func_201520_a(this.width, this.height, this.minecraft, this.widthTooNarrow, (RecipeBookContainer)this.field_147002_h);
            this.updateScreenPosition();
            this.children.add(this.recipeBookGui);
            this.func_212928_a((IGuiEventListener)this.recipeBookGui);
            Tuple<Integer, Integer> offsets = CuriosScreen.getButtonOffset(false);
            this.buttonCurios = new GuiButtonCurios(this, this.getGuiLeft() + (Integer)offsets.func_76341_a(), this.height / 2 + (Integer)offsets.func_76340_b(), 14, 14, 50, 0, 14, CURIO_INVENTORY);
            this.addButton((Widget)this.buttonCurios);
            if (!this.field_213127_e.field_70458_d.func_184812_l_()) {
                this.addButton((Widget)new ImageButton(this.field_147003_i + 104, this.height / 2 - 22, 20, 18, 0, 0, 19, RECIPE_BUTTON_TEXTURE, button -> {
                    this.recipeBookGui.func_201518_a(this.widthTooNarrow);
                    this.recipeBookGui.func_191866_a();
                    this.updateScreenPosition();
                    ((ImageButton)button).func_191746_c(this.field_147003_i + 104, this.height / 2 - 22);
                    this.buttonCurios.func_191746_c(this.field_147003_i + (Integer)offsets.func_76341_a(), this.height / 2 + (Integer)offsets.func_76340_b());
                }));
            }
        }
    }

    private void updateScreenPosition() {
        int i = this.recipeBookGui.func_191878_b() && !this.widthTooNarrow ? 177 + (this.width - this.field_146999_f - (this.hasScrollBar ? 118 : 148)) / 2 : (this.width - this.field_146999_f) / 2;
        this.field_147003_i = i;
    }

    public void tick() {
        super.tick();
        this.recipeBookGui.func_193957_d();
    }

    public static Tuple<Integer, Integer> getButtonOffset(boolean isCreative) {
        CuriosConfig.Client client = CuriosConfig.CLIENT;
        CuriosConfig.Client.ButtonCorner corner = (CuriosConfig.Client.ButtonCorner)((Object)client.buttonCorner.get());
        int x = 0;
        int y = 0;
        if (isCreative) {
            x += corner.getCreativeXoffset() + (Integer)client.creativeButtonXOffset.get();
            y += corner.getCreativeYoffset() + (Integer)client.creativeButtonYOffset.get();
        } else {
            x += corner.getXoffset() + (Integer)client.buttonXOffset.get();
            y += corner.getYoffset() + (Integer)client.buttonYOffset.get();
        }
        return new Tuple((Object)x, (Object)y);
    }

    private boolean inScrollBar(double mouseX, double mouseY) {
        int i = this.field_147003_i;
        int j = this.field_147009_r;
        int k = i - 34;
        int l = j + 12;
        int i1 = k + 14;
        int j1 = l + 139;
        return mouseX >= (double)k && mouseY >= (double)l && mouseX < (double)i1 && mouseY < (double)j1;
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        this.renderBackground();
        if (this.recipeBookGui.func_191878_b() && this.widthTooNarrow) {
            this.func_146976_a(partialTicks, mouseX, mouseY);
            this.recipeBookGui.render(mouseX, mouseY, partialTicks);
        } else {
            this.recipeBookGui.render(mouseX, mouseY, partialTicks);
            super.render(mouseX, mouseY, partialTicks);
            this.recipeBookGui.func_191864_a(this.field_147003_i, this.field_147009_r, true, partialTicks);
        }
        this.func_191948_b(mouseX, mouseY);
    }

    public boolean keyPressed(int p_keyPressed_1_, int p_keyPressed_2_, int p_keyPressed_3_) {
        if (this.recipeBookGui.func_191878_b() && this.widthTooNarrow) {
            this.recipeBookGui.func_191866_a();
            this.updateScreenPosition();
            return true;
        }
        if (KeyRegistry.openCurios.isActiveAndMatches(InputMappings.func_197954_a((int)p_keyPressed_1_, (int)p_keyPressed_2_))) {
            ClientPlayerEntity playerEntity = this.getMinecraft().field_71439_g;
            if (playerEntity != null) {
                playerEntity.func_71053_j();
            }
            return true;
        }
        return super.keyPressed(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_);
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        if (this.minecraft != null && this.minecraft.field_71439_g != null) {
            Slot slot;
            this.minecraft.field_71466_p.func_211126_b(I18n.func_135052_a((String)"container.crafting", (Object[])new Object[0]), 97.0f, 8.0f, 0x404040);
            if (this.minecraft.field_71439_g.field_71071_by.func_70445_o().func_190926_b() && this.getSlotUnderMouse() != null && (slot = this.getSlotUnderMouse()) instanceof SlotCurio && !slot.func_75216_d()) {
                SlotCurio slotCurio = (SlotCurio)slot;
                this.renderTooltip(slotCurio.getSlotName(), mouseX - this.field_147003_i, mouseY - this.field_147009_r);
            }
        }
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        if (this.minecraft != null && this.minecraft.field_71439_g != null) {
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.minecraft.func_110434_K().func_110577_a(field_147001_a);
            int i = this.field_147003_i;
            int j = this.field_147009_r;
            this.blit(i, j, 0, 0, this.field_146999_f, this.field_147000_g);
            InventoryScreen.func_228187_a_((int)(i + 51), (int)(j + 75), (int)30, (float)((float)(i + 51) - (float)mouseX), (float)((float)(j + 75 - 50) - (float)mouseY), (LivingEntity)this.minecraft.field_71439_g);
            CuriosAPI.getCuriosHandler((LivingEntity)this.minecraft.field_71439_g).ifPresent(handler -> {
                int slotCount = handler.getSlots();
                int upperHeight = 7 + slotCount * 18;
                RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                this.getMinecraft().func_110434_K().func_110577_a(CURIO_INVENTORY);
                this.blit(i - 26, j + 4, 0, 0, 27, upperHeight);
                if (slotCount <= 8) {
                    this.blit(i - 26, j + 4 + upperHeight, 0, 151, 27, 7);
                } else {
                    this.blit(i - 42, j + 4, 27, 0, 23, 158);
                    this.getMinecraft().func_110434_K().func_110577_a(CREATIVE_INVENTORY_TABS);
                    this.blit(i - 34, j + 12 + (int)(127.0f * this.currentScroll), 232, 0, 12, 15);
                }
            });
        }
    }

    protected boolean func_195359_a(int rectX, int rectY, int rectWidth, int rectHeight, double pointX, double pointY) {
        return (!this.widthTooNarrow || !this.recipeBookGui.func_191878_b()) && super.func_195359_a(rectX, rectY, rectWidth, rectHeight, pointX, pointY);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        if (this.recipeBookGui.mouseClicked(mouseX, mouseY, mouseButton)) {
            return true;
        }
        if (this.inScrollBar(mouseX, mouseY)) {
            this.isScrolling = this.needsScrollBars();
            return true;
        }
        return this.widthTooNarrow && this.recipeBookGui.func_191878_b() || super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    public boolean mouseReleased(double mouseReleased1, double mouseReleased3, int mouseReleased5) {
        if (mouseReleased5 == 0) {
            this.isScrolling = false;
        }
        if (this.buttonClicked) {
            this.buttonClicked = false;
            return true;
        }
        return super.mouseReleased(mouseReleased1, mouseReleased3, mouseReleased5);
    }

    public boolean mouseDragged(double pMouseDragged1, double pMouseDragged3, int pMouseDragged5, double pMouseDragged6, double pMouseDragged8) {
        if (this.isScrolling) {
            int i = this.field_147009_r + 18;
            int j = i + 112;
            this.currentScroll = ((float)pMouseDragged3 - (float)i - 7.5f) / ((float)(j - i) - 15.0f);
            this.currentScroll = MathHelper.func_76131_a((float)this.currentScroll, (float)0.0f, (float)1.0f);
            ((CuriosContainer)this.field_147002_h).scrollTo(this.currentScroll);
            return true;
        }
        return super.mouseDragged(pMouseDragged1, pMouseDragged3, pMouseDragged5, pMouseDragged6, pMouseDragged8);
    }

    public boolean mouseScrolled(double pMouseScrolled1, double pMouseScrolled3, double pMouseScrolled5) {
        if (!this.needsScrollBars()) {
            return false;
        }
        int i = (Integer)((CuriosContainer)this.field_147002_h).curios.map(ICurioItemHandler::getSlots).orElse((Object)1);
        this.currentScroll = (float)((double)this.currentScroll - pMouseScrolled5 / (double)i);
        this.currentScroll = MathHelper.func_76131_a((float)this.currentScroll, (float)0.0f, (float)1.0f);
        ((CuriosContainer)this.field_147002_h).scrollTo(this.currentScroll);
        return true;
    }

    private boolean needsScrollBars() {
        return ((CuriosContainer)this.field_147002_h).canScroll();
    }

    protected boolean func_195361_a(double mouseX, double mouseY, int guiLeftIn, int guiTopIn, int mouseButton) {
        boolean flag = mouseX < (double)guiLeftIn || mouseY < (double)guiTopIn || mouseX >= (double)(guiLeftIn + this.field_146999_f) || mouseY >= (double)(guiTopIn + this.field_147000_g);
        return this.recipeBookGui.func_195604_a(mouseX, mouseY, this.field_147003_i, this.field_147009_r, this.field_146999_f, this.field_147000_g, mouseButton) && flag;
    }

    protected void func_184098_a(Slot slotIn, int slotId, int mouseButton, ClickType type) {
        super.func_184098_a(slotIn, slotId, mouseButton, type);
        this.recipeBookGui.func_191874_a(slotIn);
    }

    public void func_192043_J_() {
        this.recipeBookGui.func_193948_e();
    }

    public void removed() {
        this.recipeBookGui.func_191871_c();
        super.removed();
    }

    @Nonnull
    public RecipeBookGui func_194310_f() {
        return this.recipeBookGui;
    }
}

