/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.tile.tier3;

import com.bluepowermod.api.power.BlutricityStorage;
import com.bluepowermod.api.power.CapabilityBlutricity;
import com.bluepowermod.api.power.IPowerBase;
import com.bluepowermod.helper.EnergyHelper;
import com.bluepowermod.tile.BPTileEntityType;
import com.bluepowermod.tile.TileMachineBase;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;

public class TileSolarPanel
extends TileMachineBase {
    private final int MAX_VOLTAGE = 100;
    private final BlutricityStorage storage = new BlutricityStorage(100.0, 100.0);
    private LazyOptional<IPowerBase> blutricityCap;

    public TileSolarPanel() {
        super(BPTileEntityType.SOLAR_PANEL);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityBlutricity.BLUTRICITY_CAPABILITY) {
            if (this.blutricityCap == null) {
                this.blutricityCap = LazyOptional.of(() -> this.storage);
            }
            return this.blutricityCap.cast();
        }
        return LazyOptional.empty();
    }

    @Override
    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            this.storage.resetCurrent();
            if (this.field_145850_b.func_72935_r() && this.field_145850_b.func_175710_j(this.field_174879_c) && this.storage.getEnergy() < 100.0 && !this.field_145850_b.func_72896_J()) {
                this.storage.addEnergy(0.2, false);
            }
            for (Direction facing : Direction.values()) {
                TileEntity tile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(facing));
                if (tile == null) continue;
                tile.getCapability(CapabilityBlutricity.BLUTRICITY_CAPABILITY, facing.func_176734_d()).ifPresent(exStorage -> EnergyHelper.balancePower(exStorage, this.storage));
            }
        }
    }

    @Override
    protected void readFromPacketNBT(CompoundNBT tCompound) {
        super.readFromPacketNBT(tCompound);
        if (tCompound.func_74764_b("energy")) {
            INBT nbtstorage = tCompound.func_74781_a("energy");
            CapabilityBlutricity.BLUTRICITY_CAPABILITY.getStorage().readNBT(CapabilityBlutricity.BLUTRICITY_CAPABILITY, (Object)this.storage, null, nbtstorage);
        }
    }

    @Override
    protected void writeToPacketNBT(CompoundNBT tCompound) {
        super.writeToPacketNBT(tCompound);
        INBT nbtstorage = CapabilityBlutricity.BLUTRICITY_CAPABILITY.getStorage().writeNBT(CapabilityBlutricity.BLUTRICITY_CAPABILITY, (Object)this.storage, null);
        tCompound.func_218657_a("energy", nbtstorage);
    }

    protected void invalidateCaps() {
        super.invalidateCaps();
        if (this.blutricityCap != null) {
            this.blutricityCap.invalidate();
            this.blutricityCap = null;
        }
    }
}

