/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.helper;

import com.bluepowermod.api.tube.IPneumaticTube;
import com.bluepowermod.api.tube.ITubeConnection;
import com.bluepowermod.helper.ItemStackHelper;
import net.minecraft.block.BlockState;
import net.minecraft.block.ChestBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class IOHelper {
    public static IInventory getInventoryForTE(TileEntity te) {
        if (te instanceof IInventory) {
            IInventory inv = (IInventory)te;
            BlockState block = te.func_195044_w();
            if (block.func_177230_c() instanceof ChestBlock) {
                inv = (IInventory)((ChestBlock)block.func_177230_c()).func_220052_b(block, te.func_145831_w(), te.func_174877_v());
            }
            return inv;
        }
        return null;
    }

    public static ItemStack extract(TileEntity inventory, Direction direction, boolean simulate) {
        IInventory inv = IOHelper.getInventoryForTE(inventory);
        if (inv != null) {
            return IOHelper.extract(inv, direction, simulate);
        }
        return ItemStack.field_190927_a;
    }

    public static ItemStack extract(IInventory inventory, Direction direction, boolean simulate) {
        if (inventory instanceof ISidedInventory) {
            int[] accessibleSlotsFromSide;
            ISidedInventory isidedinventory = (ISidedInventory)inventory;
            for (int anAccessibleSlotsFromSide : accessibleSlotsFromSide = isidedinventory.func_180463_a(direction)) {
                ItemStack stack = IOHelper.extract(inventory, direction, anAccessibleSlotsFromSide, simulate);
                if (stack.func_190926_b()) continue;
                return stack;
            }
        } else {
            int j = inventory.func_70302_i_();
            for (int k = 0; k < j; ++k) {
                ItemStack stack = IOHelper.extract(inventory, direction, k, simulate);
                if (stack.func_190926_b()) continue;
                return stack;
            }
        }
        return ItemStack.field_190927_a;
    }

    public static ItemStack extract(IInventory inventory, Direction direction, int slot, boolean simulate) {
        ItemStack itemstack = inventory.func_70301_a(slot);
        if (!itemstack.func_190926_b() && IOHelper.canExtractItemFromInventory(inventory, itemstack, slot, direction.ordinal())) {
            if (!simulate) {
                inventory.func_70299_a(slot, ItemStack.field_190927_a);
            }
            return itemstack;
        }
        return ItemStack.field_190927_a;
    }

    public static ItemStack extract(TileEntity tile, Direction direction, ItemStack requestedStack, boolean useItemCount, boolean simulate) {
        return IOHelper.extract(tile, direction, requestedStack, useItemCount, simulate, 0);
    }

    public static int[] getAccessibleSlotsForInventory(IInventory inv, Direction side) {
        if (inv != null) {
            int[] accessibleSlots;
            if (inv instanceof ISidedInventory) {
                accessibleSlots = ((ISidedInventory)inv).func_180463_a(side);
            } else {
                accessibleSlots = new int[inv.func_70302_i_()];
                for (int i = 0; i < accessibleSlots.length; ++i) {
                    accessibleSlots[i] = i;
                }
            }
            return accessibleSlots;
        }
        return new int[0];
    }

    public static int getItemCount(ItemStack type, TileEntity inv, Direction side, int fuzzySetting) {
        IInventory inventory = IOHelper.getInventoryForTE(inv);
        int[] slots = IOHelper.getAccessibleSlotsForInventory(inventory, side);
        int count = 0;
        for (int slot : slots) {
            ItemStack invStack = inventory.func_70301_a(slot);
            if (invStack.func_190926_b() || !ItemStackHelper.areStacksEqual(invStack, type, fuzzySetting)) continue;
            count += invStack.func_190916_E();
        }
        return count;
    }

    public static ItemStack extract(TileEntity tile, Direction direction, ItemStack requestedStack, boolean useItemCount, boolean simulate, int fuzzySetting) {
        if (requestedStack.func_190926_b()) {
            return requestedStack;
        }
        IInventory inv = IOHelper.getInventoryForTE(tile);
        if (!inv.func_191420_l()) {
            int[] accessibleSlots;
            if (inv instanceof ISidedInventory) {
                accessibleSlots = ((ISidedInventory)inv).func_180463_a(direction);
            } else {
                accessibleSlots = new int[inv.func_70302_i_()];
                for (int i = 0; i < accessibleSlots.length; ++i) {
                    accessibleSlots[i] = i;
                }
            }
            int itemsFound = 0;
            for (int slot : accessibleSlots) {
                ItemStack stack = inv.func_70301_a(slot);
                if (stack.func_190926_b() || !ItemStackHelper.areStacksEqual(stack, requestedStack, fuzzySetting) || !IOHelper.canExtractItemFromInventory(inv, requestedStack, slot, direction.ordinal())) continue;
                if (!useItemCount) {
                    if (!simulate) {
                        inv.func_70299_a(slot, ItemStack.field_190927_a);
                    }
                    return stack;
                }
                itemsFound += stack.func_190916_E();
            }
            if (itemsFound >= requestedStack.func_190916_E()) {
                ItemStack exportedStack = ItemStack.field_190927_a;
                int itemsNeeded = requestedStack.func_190916_E();
                for (int slot : accessibleSlots) {
                    ItemStack stack = inv.func_70301_a(slot);
                    if (stack.func_190926_b() || !ItemStackHelper.areStacksEqual(stack, requestedStack, fuzzySetting) || !IOHelper.canExtractItemFromInventory(inv, requestedStack, slot, direction.ordinal())) continue;
                    int itemsSubstracted = Math.min(itemsNeeded, stack.func_190916_E());
                    if (itemsSubstracted > 0) {
                        exportedStack = stack;
                    }
                    itemsNeeded -= itemsSubstracted;
                    if (simulate) continue;
                    stack.func_190920_e(stack.func_190916_E() - itemsSubstracted);
                    if (stack.func_190916_E() == 0) {
                        inv.func_70299_a(slot, ItemStack.field_190927_a);
                    }
                    tile.func_70296_d();
                }
                exportedStack = exportedStack.func_77946_l();
                exportedStack.func_190920_e(requestedStack.func_190916_E());
                return exportedStack;
            }
        }
        return ItemStack.field_190927_a;
    }

    public static ItemStack extractOneItem(TileEntity tile, Direction dir) {
        IInventory inv = IOHelper.getInventoryForTE(tile);
        if (!inv.func_191420_l()) {
            int[] accessibleSlots;
            if (inv instanceof ISidedInventory) {
                accessibleSlots = ((ISidedInventory)inv).func_180463_a(dir);
            } else {
                accessibleSlots = new int[inv.func_70302_i_()];
                for (int i = 0; i < accessibleSlots.length; ++i) {
                    accessibleSlots[i] = i;
                }
            }
            for (int slot : accessibleSlots) {
                ItemStack retrievingStack;
                ItemStack stack = inv.func_70301_a(slot);
                ItemStack itemStack = retrievingStack = stack.func_190926_b() ? ItemStack.field_190927_a : stack.func_77946_l().func_77979_a(1);
                if (stack.func_190926_b() || !IOHelper.canExtractItemFromInventory(inv, retrievingStack, slot, dir.ordinal())) continue;
                ItemStack ret = stack.func_77979_a(1);
                if (stack.func_190916_E() == 0) {
                    inv.func_70299_a(slot, ItemStack.field_190927_a);
                }
                tile.func_70296_d();
                return ret;
            }
        }
        return ItemStack.field_190927_a;
    }

    public static ItemStack insert(TileEntity tile, ItemStack itemStack, Direction direction, boolean simulate) {
        return IOHelper.insert(tile, itemStack, direction, IPneumaticTube.TubeColor.NONE, simulate);
    }

    public static ItemStack insert(TileEntity tile, ItemStack itemStack, Direction direction, IPneumaticTube.TubeColor color, boolean simulate) {
        if (tile == null || itemStack.func_190926_b()) {
            return itemStack;
        }
        return itemStack;
    }

    public static ItemStack insert(IInventory inventory, ItemStack itemStack, int side, boolean simulate) {
        if (inventory instanceof ISidedInventory && side > -1) {
            ISidedInventory isidedinventory = (ISidedInventory)inventory;
            int[] aint = isidedinventory.func_180463_a(Direction.func_82600_a((int)side));
            for (int j = 0; j < aint.length && !itemStack.func_190926_b() && itemStack.func_190916_E() > 0; ++j) {
                itemStack = IOHelper.insert(inventory, itemStack, aint[j], side, simulate);
            }
        } else {
            int k = inventory.func_70302_i_();
            for (int l = 0; l < k && !itemStack.func_190926_b() && itemStack.func_190916_E() > 0; ++l) {
                itemStack = IOHelper.insert(inventory, itemStack, l, side, simulate);
            }
        }
        if (!itemStack.func_190926_b() && itemStack.func_190916_E() == 0) {
            itemStack = ItemStack.field_190927_a;
        }
        return itemStack;
    }

    public static ItemStack insert(IInventory inventory, ItemStack itemStack, int slot, int side, boolean simulate) {
        ItemStack itemstack1 = inventory.func_70301_a(slot);
        if (IOHelper.canInsertItemToInventory(inventory, itemStack, slot, side)) {
            int max;
            boolean flag = false;
            if (itemstack1.func_190926_b()) {
                int max2 = Math.min(itemStack.func_77976_d(), inventory.func_70297_j_());
                if (max2 >= itemStack.func_190916_E()) {
                    if (!simulate) {
                        inventory.func_70299_a(slot, itemStack);
                        flag = true;
                    }
                    itemStack = ItemStack.field_190927_a;
                } else if (!simulate) {
                    inventory.func_70299_a(slot, itemStack.func_77979_a(max2));
                    flag = true;
                } else {
                    itemStack.func_77979_a(max2);
                }
            } else if (ItemStackHelper.areItemStacksEqual(itemstack1, itemStack) && (max = Math.min(itemStack.func_77976_d(), inventory.func_70297_j_())) > itemstack1.func_190916_E()) {
                int l = Math.min(itemStack.func_190916_E(), max - itemstack1.func_190916_E());
                itemStack.func_190920_e(itemStack.func_190916_E() - l);
                if (!simulate) {
                    itemstack1.func_190920_e(itemstack1.func_190916_E() + l);
                    boolean bl = flag = l > 0;
                }
            }
            if (flag) {
                inventory.func_70296_d();
            }
        }
        return itemStack;
    }

    public static boolean canInsertItemToInventory(IInventory inventory, ItemStack itemStack, int slot, int side) {
        return inventory.func_94041_b(slot, itemStack) && (!(inventory instanceof ISidedInventory) || ((ISidedInventory)inventory).func_180462_a(slot, itemStack, Direction.func_82600_a((int)side)));
    }

    public static boolean canExtractItemFromInventory(IInventory inventory, ItemStack itemStack, int slot, int side) {
        return !(inventory instanceof ISidedInventory) || ((ISidedInventory)inventory).func_180461_b(slot, itemStack, Direction.func_82600_a((int)side));
    }

    public static void dropInventory(World world, BlockPos pos) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (!(tileEntity instanceof IInventory)) {
            return;
        }
        IInventory inventory = (IInventory)tileEntity;
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack itemStack = inventory.func_70301_a(i);
            if (itemStack.func_190926_b() || itemStack.func_190916_E() <= 0) continue;
            IOHelper.spawnItemInWorld(world, itemStack, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
    }

    public static void spawnItemInWorld(World world, ItemStack itemStack, BlockPos pos) {
        IOHelper.spawnItemInWorld(world, itemStack, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    public static void spawnItemInWorld(World world, ItemStack itemStack, double x, double y, double z) {
        if (world.field_72995_K) {
            return;
        }
        float dX = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
        float dY = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
        float dZ = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
        ItemEntity entityItem = new ItemEntity(world, x + (double)dX, y + (double)dY, z + (double)dZ, new ItemStack((IItemProvider)itemStack.func_77973_b(), itemStack.func_190916_E()));
        if (itemStack.func_77942_o()) {
            entityItem.func_92059_d().func_77982_d(itemStack.func_77978_p().func_74737_b());
        }
        float factor = 0.05f;
        entityItem.func_213293_j(world.field_73012_v.nextGaussian() * (double)factor, world.field_73012_v.nextGaussian() * (double)factor + (double)0.2f, world.field_73012_v.nextGaussian() * (double)factor);
        world.func_217376_c((Entity)entityItem);
        itemStack.func_190920_e(0);
    }

    public static boolean canInterfaceWith(TileEntity tile, Direction direction) {
        return IOHelper.canInterfaceWith(tile, direction, true);
    }

    public static boolean canInterfaceWith(TileEntity tile, Direction direction, boolean canInterfaceWithIInventory) {
        if (!canInterfaceWithIInventory) {
            return false;
        }
        if (tile instanceof ITubeConnection) {
            return true;
        }
        if (tile instanceof IInventory) {
            return !(tile instanceof ISidedInventory) || ((ISidedInventory)tile).func_180463_a(direction).length > 0;
        }
        return false;
    }
}

