/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.container;

import com.bluepowermod.client.gui.BPContainerType;
import com.bluepowermod.client.gui.IGuiButtonSensitive;
import com.bluepowermod.container.inventory.InventoryProjectTableCrafting;
import com.bluepowermod.container.slot.SlotProjectTableCrafting;
import java.util.Optional;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.CraftResultInventory;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SSetSlotPacket;
import net.minecraft.world.World;

public class ContainerProjectTable
extends Container
implements IGuiButtonSensitive {
    private final PlayerEntity player;
    private final CraftingInventory craftingGrid;
    private final CraftResultInventory craftResult;
    private final IInventory projectTable;

    public ContainerProjectTable(int windowId, PlayerInventory invPlayer, IInventory inventory) {
        super(BPContainerType.PROJECT_TABLE, windowId);
        int j;
        int i;
        this.projectTable = inventory;
        this.craftResult = new CraftResultInventory();
        this.craftingGrid = new InventoryProjectTableCrafting(this, this.projectTable, 3, 3);
        this.player = invPlayer.field_70458_d;
        this.func_75146_a((Slot)new SlotProjectTableCrafting(this.projectTable, this.player, this.craftingGrid, this.craftResult, 0, 127, 34));
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 3; ++j) {
                this.func_75146_a(new Slot((IInventory)this.craftingGrid, j + i * 3, 34 + j * 18, 16 + i * 18));
            }
        }
        for (i = 0; i < 2; ++i) {
            for (j = 0; j < 9; ++j) {
                this.func_75146_a(new Slot(this.projectTable, j + i * 9, 8 + j * 18, 79 + i * 18));
            }
        }
        this.bindPlayerInventory(invPlayer);
        this.func_75130_a((IInventory)this.craftingGrid);
    }

    public ContainerProjectTable(int id, PlayerInventory player) {
        this(id, player, (IInventory)new Inventory(28));
    }

    protected void bindPlayerInventory(PlayerInventory invPlayer) {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.func_75146_a(new Slot((IInventory)invPlayer, j + i * 9 + 9, 8 + j * 18, 126 + i * 18));
            }
        }
        for (int j = 0; j < 9; ++j) {
            this.func_75146_a(new Slot((IInventory)invPlayer, j, 8 + j * 18, 184));
        }
    }

    protected static void updateCrafting(int id, World world, PlayerEntity playerEntity, CraftingInventory craftingInventory, CraftResultInventory craftResultInventory) {
        if (!world.field_72995_K) {
            ICraftingRecipe icraftingrecipe;
            ServerPlayerEntity serverplayerentity = (ServerPlayerEntity)playerEntity;
            ItemStack itemstack = ItemStack.field_190927_a;
            Optional optional = world.func_73046_m().func_199529_aN().func_215371_a(IRecipeType.field_222149_a, (IInventory)craftingInventory, world);
            if (optional.isPresent() && craftResultInventory.func_201561_a(world, serverplayerentity, (IRecipe)(icraftingrecipe = (ICraftingRecipe)optional.get()))) {
                itemstack = icraftingrecipe.func_77572_b((IInventory)craftingInventory);
            }
            craftResultInventory.func_70299_a(0, itemstack);
            serverplayerentity.field_71135_a.func_147359_a((IPacket)new SSetSlotPacket(id, 0, itemstack));
        }
    }

    public void func_75130_a(IInventory inventoryIn) {
        ContainerProjectTable.updateCrafting(this.field_75152_c, this.player.func_130014_f_(), this.player, this.craftingGrid, this.craftResult);
    }

    public boolean func_75145_c(PlayerEntity playerIn) {
        return true;
    }

    public void clearCraftingGrid() {
        for (int i = 1; i < 10; ++i) {
            Slot slot = (Slot)this.field_75151_b.get(i);
            if (!slot.func_75216_d()) continue;
            this.func_75135_a(slot.func_75211_c(), 10, 28, false);
            if (slot.func_75211_c().func_190916_E() > 0) continue;
            slot.func_75215_d(ItemStack.field_190927_a);
        }
    }

    public boolean func_94530_a(ItemStack stack, Slot slotIn) {
        return slotIn.field_75224_c != this.craftResult && super.func_94530_a(stack, slotIn);
    }

    public CraftingInventory getCraftingGrid() {
        return this.craftingGrid;
    }

    public ItemStack func_82846_b(PlayerEntity player, int par2) {
        ItemStack itemstack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(par2);
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemstack1 = slot.func_75211_c();
            itemstack = itemstack1.func_77946_l();
            if (0 < par2 && par2 < 10 ? !this.func_75135_a(itemstack1, 10, 28, false) : (par2 < 28 ? !this.func_75135_a(itemstack1, 28, 64, false) : !this.func_75135_a(itemstack1, 10, 28, false))) {
                return ItemStack.field_190927_a;
            }
            if (itemstack1.func_190916_E() == 0) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (itemstack1.func_190916_E() == itemstack.func_190916_E()) {
                this.func_75130_a((IInventory)this.craftingGrid);
                return ItemStack.field_190927_a;
            }
            slot.func_75220_a(itemstack, itemstack1);
            ItemStack itemstack2 = slot.func_190901_a(player, itemstack1);
            if (par2 == 0) {
                player.func_71019_a(itemstack2, false);
            }
        }
        this.func_75130_a((IInventory)this.craftingGrid);
        return itemstack;
    }

    @Override
    public void onButtonPress(PlayerEntity player, int messageId, int value) {
        this.clearCraftingGrid();
    }
}

