/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.api.power;

import com.bluepowermod.api.power.BlutricityStorage;
import net.minecraftforge.energy.IEnergyStorage;

public class BlutricityFEStorage
extends BlutricityStorage
implements IEnergyStorage {
    public BlutricityFEStorage(double max) {
        super(max / 10.0, 100.0);
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        if (!this.canReceive()) {
            return 0;
        }
        int energyReceived = Math.min((int)this.maxEnergy * 10 - (int)this.energy * 10, Math.min((int)this.maxEnergy * 10, maxReceive));
        if (!simulate) {
            this.energy += (double)(energyReceived / 10);
        }
        return energyReceived;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        if (!this.canExtract()) {
            return 0;
        }
        int energyExtracted = Math.min((int)this.energy * 10, Math.min((int)this.maxEnergy * 10, maxExtract));
        if (!simulate) {
            this.energy -= (double)(energyExtracted / 10);
        }
        return energyExtracted;
    }

    public int getEnergyStored() {
        return (int)this.energy * 10;
    }

    public int getMaxEnergyStored() {
        return (int)this.maxEnergy * 10;
    }

    public boolean canExtract() {
        return (int)this.energy > 0;
    }

    public boolean canReceive() {
        return (int)this.energy < (int)this.maxEnergy;
    }
}

