/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsstorage.storage;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import mcjty.rftoolsstorage.setup.RFToolsStorageMessages;
import mcjty.rftoolsstorage.storage.StorageEntry;
import mcjty.rftoolsstorage.storage.network.PacketRequestStorageFromServer;

public class ClientStorageHolder {
    private final Map<UUID, StorageEntry> storageEntryMap = new HashMap<UUID, StorageEntry>();

    @Nullable
    public StorageEntry getStorage(UUID uuid, int version) {
        if (!this.storageEntryMap.containsKey(uuid)) {
            this.requestData(uuid);
            return null;
        }
        StorageEntry entry = this.storageEntryMap.get(uuid);
        if (entry.getVersion() != version) {
            this.requestData(uuid);
        }
        return entry;
    }

    private void requestData(UUID uuid) {
        RFToolsStorageMessages.INSTANCE.sendToServer((Object)new PacketRequestStorageFromServer(uuid));
    }

    public void registerStorage(UUID uuid, StorageEntry entry) {
        this.storageEntryMap.put(uuid, entry);
    }
}

