/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsstorage.modules.modularstorage.blocks;

import mcjty.lib.container.BaseSlot;
import mcjty.lib.container.ContainerFactory;
import mcjty.lib.container.GenericContainer;
import mcjty.lib.container.SlotDefinition;
import mcjty.lib.container.SlotFactory;
import mcjty.lib.container.SlotType;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.rftoolsbase.modules.filter.items.FilterModuleItem;
import mcjty.rftoolsstorage.craftinggrid.CraftingGridInventory;
import mcjty.rftoolsstorage.modules.modularstorage.ModularStorageSetup;
import mcjty.rftoolsstorage.modules.modularstorage.blocks.ModularStorageTileEntity;
import mcjty.rftoolsstorage.modules.modularstorage.client.SlotOffsetCalculator;
import mcjty.rftoolsstorage.modules.modularstorage.items.StorageModuleItem;
import mcjty.rftoolsstorage.modules.modularstorage.network.PacketStorageInfoToClient;
import mcjty.rftoolsstorage.setup.RFToolsStorageMessages;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.IContainerListener;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;

public class ModularStorageContainer
extends GenericContainer {
    public static final String CONTAINER_GRID = "grid";
    public static final String CONTAINER_CARDS = "cards";
    public static final int SLOT_STORAGE_MODULE = 0;
    public static final int SLOT_TYPE_MODULE = 1;
    public static final int SLOT_FILTER_MODULE = 2;
    public static final int SLOT_STORAGE = 3;
    public static final int MAXSIZE_STORAGE = 500;
    public static final Lazy<ContainerFactory> CONTAINER_FACTORY = Lazy.of(() -> new ContainerFactory(3).slot(SlotDefinition.specific(stack -> stack.func_77973_b() instanceof StorageModuleItem), CONTAINER_CARDS, 0, 5, 157).slot(SlotDefinition.specific(stack -> false), CONTAINER_CARDS, 1, 5, 175).slot(SlotDefinition.specific(stack -> stack.func_77973_b() instanceof FilterModuleItem), CONTAINER_CARDS, 2, 5, 193).box(SlotDefinition.input(), "container", 0, -500, -500, 500, 0, 1, 0).playerSlots(91, 157).box(SlotDefinition.ghost(), CONTAINER_GRID, 1, CraftingGridInventory.GRID_XOFFSET, 127, 3, 3).range(SlotDefinition.ghostOut(), CONTAINER_GRID, 0, CraftingGridInventory.GRID_XOFFSET, 185, 1, 18));

    public ModularStorageContainer(int id, BlockPos pos, PlayerEntity player, ModularStorageTileEntity tileEntity) {
        super((ContainerType)ModularStorageSetup.CONTAINER_MODULAR_STORAGE.get(), id, (ContainerFactory)CONTAINER_FACTORY.get(), pos, (GenericTileEntity)tileEntity);
    }

    public void setupInventories(IItemHandler itemHandler, PlayerInventory inventory) {
        ModularStorageTileEntity modularStorageTileEntity = (ModularStorageTileEntity)this.te;
        this.addInventory(CONTAINER_CARDS, modularStorageTileEntity.getCardHandler());
        this.addInventory("container", itemHandler);
        this.addInventory("player", (IItemHandler)new InvWrapper((IInventory)inventory));
        this.addInventory(CONTAINER_GRID, (IItemHandler)modularStorageTileEntity.getCraftingGrid().getCraftingGridInventory());
        this.generateSlots();
    }

    private int getAdjustedY(int y, boolean onClient) {
        if (onClient) {
            return y + SlotOffsetCalculator.getYOffset();
        }
        return y;
    }

    public void generateSlots() {
        boolean onClient = this.getTe().func_145831_w().func_201670_d();
        for (SlotFactory slotFactory : ((ContainerFactory)CONTAINER_FACTORY.get()).getSlots()) {
            Object slot;
            if (CONTAINER_GRID.equals(slotFactory.getInventoryName())) {
                SlotType slotType = slotFactory.getSlotType();
                IItemHandler inventory = (IItemHandler)this.inventories.get(slotFactory.getInventoryName());
                int index = slotFactory.getIndex();
                int x = slotFactory.getX();
                int y = slotFactory.getY();
                slot = this.createSlot(slotFactory, inventory, index, x, y, slotType);
            } else if (slotFactory.getSlotType() == SlotType.SLOT_SPECIFICITEM) {
                final SlotDefinition slotDefinition = slotFactory.getSlotDefinition();
                slot = new SlotItemHandler((IItemHandler)this.inventories.get(slotFactory.getInventoryName()), slotFactory.getIndex(), slotFactory.getX(), this.getAdjustedY(slotFactory.getY(), onClient)){

                    public boolean func_75214_a(ItemStack stack) {
                        return slotDefinition.itemStackMatches(stack);
                    }
                };
            } else {
                slot = slotFactory.getSlotType() == SlotType.SLOT_PLAYERINV || slotFactory.getSlotType() == SlotType.SLOT_PLAYERHOTBAR ? new BaseSlot((IItemHandler)this.inventories.get(slotFactory.getInventoryName()), this.te, slotFactory.getIndex(), slotFactory.getX(), this.getAdjustedY(slotFactory.getY(), onClient)) : new BaseSlot((IItemHandler)this.inventories.get(slotFactory.getInventoryName()), this.te, slotFactory.getIndex(), slotFactory.getX(), this.getAdjustedY(slotFactory.getY(), onClient));
            }
            this.func_75146_a((Slot)slot);
        }
    }

    public void func_75141_a(int slotID, ItemStack stack) {
        super.func_75141_a(slotID, stack);
    }

    public ItemStack func_184996_a(int index, int button, ClickType mode, PlayerEntity player) {
        if (index != 0 || !player.func_130014_f_().field_72995_K) {
            // empty if block
        }
        return super.func_184996_a(index, button, mode, player);
    }

    public void func_75142_b() {
        super.func_75142_b();
        ModularStorageTileEntity modularStorageTileEntity = (ModularStorageTileEntity)this.te;
        String sortMode = modularStorageTileEntity.getSortMode();
        String viewMode = modularStorageTileEntity.getViewMode();
        boolean groupMode = modularStorageTileEntity.isGroupMode();
        String filter = modularStorageTileEntity.getFilter();
        for (IContainerListener listener : this.field_75149_d) {
            if (!(listener instanceof PlayerEntity)) continue;
            PlayerEntity player = (PlayerEntity)listener;
            RFToolsStorageMessages.INSTANCE.sendTo((Object)new PacketStorageInfoToClient(modularStorageTileEntity.func_174877_v(), sortMode, viewMode, groupMode, filter), ((ServerPlayerEntity)player).field_71135_a.field_147371_a, NetworkDirection.PLAY_TO_CLIENT);
        }
    }
}

