/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsstorage.craftinggrid;

import java.util.Optional;
import mcjty.lib.McJtyLib;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.world.World;

public class CraftingRecipe {
    private CraftingInventory inv = new CraftingInventory(new Container(null, -1){

        public boolean func_75145_c(PlayerEntity playerIn) {
            return false;
        }
    }, 3, 3);
    private ItemStack result = ItemStack.field_190927_a;
    private boolean recipePresent = false;
    private Optional<ICraftingRecipe> recipe = Optional.empty();
    private boolean keepOne = false;
    private CraftMode craftMode = CraftMode.EXT;

    public static Optional<ICraftingRecipe> findRecipe(World world, CraftingInventory inv) {
        return McJtyLib.proxy.getRecipeManager(world).func_215371_a(IRecipeType.field_222149_a, (IInventory)inv, world);
    }

    public void readFromNBT(CompoundNBT tagCompound) {
        ListNBT nbtTagList = tagCompound.func_150295_c("Items", 10);
        for (int i = 0; i < nbtTagList.size(); ++i) {
            CompoundNBT CompoundNBT2 = nbtTagList.func_150305_b(i);
            this.inv.func_70299_a(i, ItemStack.func_199557_a((CompoundNBT)CompoundNBT2));
        }
        CompoundNBT resultCompound = tagCompound.func_74775_l("Result");
        this.result = resultCompound != null ? ItemStack.func_199557_a((CompoundNBT)resultCompound) : ItemStack.field_190927_a;
        this.keepOne = tagCompound.func_74767_n("Keep");
        this.craftMode = CraftMode.values()[tagCompound.func_74771_c("Int")];
        this.recipePresent = false;
    }

    public void writeToNBT(CompoundNBT tagCompound) {
        ListNBT nbtTagList = new ListNBT();
        for (int i = 0; i < 9; ++i) {
            ItemStack stack = this.inv.func_70301_a(i);
            CompoundNBT CompoundNBT2 = new CompoundNBT();
            if (!stack.func_190926_b()) {
                stack.func_77955_b(CompoundNBT2);
            }
            nbtTagList.add((Object)CompoundNBT2);
        }
        CompoundNBT resultCompound = new CompoundNBT();
        if (!this.result.func_190926_b()) {
            this.result.func_77955_b(resultCompound);
        }
        tagCompound.func_218657_a("Result", (INBT)resultCompound);
        tagCompound.func_218657_a("Items", (INBT)nbtTagList);
        tagCompound.func_74757_a("Keep", this.keepOne);
        tagCompound.func_74774_a("Int", (byte)this.craftMode.ordinal());
    }

    public void setRecipe(ItemStack[] items, ItemStack result) {
        for (int i = 0; i < 9; ++i) {
            this.inv.func_70299_a(i, items[i]);
        }
        this.result = result;
        this.recipePresent = false;
    }

    public CraftingInventory getInventory() {
        return this.inv;
    }

    public void setResult(ItemStack result) {
        this.result = result;
    }

    public ItemStack getResult() {
        return this.result;
    }

    public Optional<ICraftingRecipe> getCachedRecipe(World world) {
        if (!this.recipePresent) {
            this.recipePresent = true;
            this.recipe = CraftingRecipe.findRecipe(world, this.inv);
        }
        return this.recipe;
    }

    public boolean isKeepOne() {
        return this.keepOne;
    }

    public void setKeepOne(boolean keepOne) {
        this.keepOne = keepOne;
    }

    public CraftMode getCraftMode() {
        return this.craftMode;
    }

    public void setCraftMode(CraftMode craftMode) {
        this.craftMode = craftMode;
    }

    public static enum CraftMode {
        EXT("Ext"),
        INT("Int"),
        EXTC("ExtC");

        private final String description;

        private CraftMode(String description) {
            this.description = description;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

