/*
 * Decompiled with CFR 0.152.
 */
package me.dags.noise.source;

import me.dags.noise.source.Builder;
import me.dags.noise.source.FastSource;
import me.dags.noise.util.Noise;
import me.dags.noise.util.NoiseUtil;

public class FastPerlin
extends FastSource {
    private static final float[] signals = new float[]{1.0f, 0.9f, 0.83f, 0.75f, 0.64f, 0.62f, 0.61f};
    protected final float min;
    protected final float max;
    protected final float range;

    public FastPerlin(Builder builder) {
        super(builder);
        this.min = this.min(builder.getOctaves(), builder.getGain());
        this.max = this.max(builder.getOctaves(), builder.getGain());
        this.range = Math.abs(this.max - this.min);
    }

    @Override
    public float getValue(float x, float y) {
        x *= this.frequency;
        y *= this.frequency;
        float sum = 0.0f;
        float amp = this.gain;
        for (int i = 0; i < this.octaves; ++i) {
            sum += Noise.singlePerlin(x, y, this.seed + i, this.interpolation) * amp;
            x *= this.lacunarity;
            y *= this.lacunarity;
            amp *= this.gain;
        }
        return NoiseUtil.map(sum, this.min, this.max, this.range);
    }

    @Override
    public float getValue(float x, float y, int seed) {
        x *= this.frequency;
        y *= this.frequency;
        float sum = 0.0f;
        float amp = this.gain;
        for (int i = 0; i < this.octaves; ++i) {
            sum += Noise.singlePerlin(x, y, seed + i, this.interpolation) * amp;
            x *= this.lacunarity;
            y *= this.lacunarity;
            amp *= this.gain;
        }
        return NoiseUtil.map(sum, this.min, this.max, this.range);
    }

    protected float min(int octaves, float gain) {
        return -this.max(octaves, gain);
    }

    protected float max(int octaves, float gain) {
        float signal = FastPerlin.signal(octaves);
        float sum = 0.0f;
        float amp = gain;
        for (int i = 0; i < octaves; ++i) {
            sum += signal * amp;
            amp *= gain;
        }
        return sum;
    }

    private static float signal(int octaves) {
        int index = Math.min(octaves, signals.length - 1);
        return signals[index];
    }
}

