/*
 * Decompiled with CFR 0.152.
 */
package me.dags.noise.modifier;

import me.dags.noise.Module;
import me.dags.noise.func.Interpolation;
import me.dags.noise.modifier.Modifier;
import me.dags.noise.util.NoiseUtil;

public class Terrace
extends Modifier {
    private final int maxIndex;
    private final Step[] steps;
    private final Module lowerCurve;
    private final Module upperCurve;

    public Terrace(Module source, Module lowerCurve, Module upperCurve, int steps, float blendRange) {
        super(source);
        this.maxIndex = steps - 1;
        this.steps = new Step[steps];
        this.lowerCurve = lowerCurve;
        this.upperCurve = upperCurve;
        float min = source.minValue();
        float max = source.maxValue();
        float range = max - min;
        float spacing = range / (float)(steps - 1);
        for (int i = 0; i < steps; ++i) {
            float value = (float)i * spacing;
            this.steps[i] = new Step(value, spacing, blendRange);
        }
    }

    @Override
    public float getValue(float x, float y) {
        float value = this.source.getValue(x, y);
        value = NoiseUtil.clamp(value, 0.0f, 1.0f);
        return this.modify(x, y, value);
    }

    @Override
    public float modify(float x, float y, float noiseValue) {
        int index = NoiseUtil.round(noiseValue * (float)this.maxIndex);
        Step step = this.steps[index];
        if (noiseValue < step.lowerBound) {
            if (index > 0) {
                Step lower = this.steps[index - 1];
                float alpha = (noiseValue - lower.upperBound) / (step.lowerBound - lower.upperBound);
                alpha = 1.0f - Interpolation.CURVE3.apply(alpha);
                float range = step.value - lower.value;
                return step.value - alpha * range * this.upperCurve.getValue(x, y);
            }
        } else if (noiseValue > step.upperBound && index < this.maxIndex) {
            Step upper = this.steps[index + 1];
            float alpha = (noiseValue - step.upperBound) / (upper.lowerBound - step.upperBound);
            alpha = Interpolation.CURVE3.apply(alpha);
            float range = upper.value - step.value;
            return step.value + alpha * range * this.lowerCurve.getValue(x, y);
        }
        return step.value;
    }

    private int getIndex(float value) {
        int index = NoiseUtil.round(value * (float)this.maxIndex);
        if (index > this.maxIndex) {
            return this.maxIndex;
        }
        if (index < 0) {
            return 0;
        }
        return index;
    }

    private static class Step {
        private final float value;
        private final float lowerBound;
        private final float upperBound;

        private Step(float value, float distance, float blendRange) {
            this.value = value;
            float blend = distance * blendRange;
            float bound = (distance - blend) / 2.0f;
            this.lowerBound = value - bound;
            this.upperBound = value + bound;
        }
    }
}

