/*
 * Decompiled with CFR 0.152.
 */
package me.dags.noise.modifier;

import me.dags.noise.Module;
import me.dags.noise.modifier.Modifier;

public class Map
extends Modifier {
    private final Module min;
    private final Module max;
    private final float sourceRange;

    public Map(Module source, Module min, Module max) {
        super(source);
        this.min = min;
        this.max = max;
        this.sourceRange = source.maxValue() - source.minValue();
    }

    @Override
    public float minValue() {
        return this.min.minValue();
    }

    @Override
    public float maxValue() {
        return this.max.maxValue();
    }

    @Override
    public float modify(float x, float y, float value) {
        float alpha = (value - this.source.minValue()) / this.sourceRange;
        float min = this.min.getValue(x, y);
        float max = this.max.getValue(x, y);
        return min + alpha * (max - min);
    }
}

