/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.util.nbt;

import com.terraforged.core.util.serialization.serializer.Writer;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.FloatNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.IntNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;

public class NBTWriter
implements Writer {
    private final Context root = new Context(null);
    private String name = "";
    private Context context = this.root;

    public INBT root() {
        return this.root.value;
    }

    public CompoundNBT compound() {
        return (CompoundNBT)this.root();
    }

    public ListNBT list() {
        return (ListNBT)this.root();
    }

    private NBTWriter begin(INBT value) {
        if (this.root.value == null) {
            this.root.value = value;
            this.context.value = value;
        } else {
            this.append(value);
            this.context = new Context(this.context);
            this.context.value = value;
        }
        return this;
    }

    private NBTWriter append(INBT value) {
        if (this.context.value instanceof CompoundNBT) {
            ((CompoundNBT)this.context.value).func_218657_a(this.name, value);
        } else if (this.context.value instanceof ListNBT) {
            ((ListNBT)this.context.value).add((Object)value);
        }
        return this;
    }

    @Override
    public NBTWriter name(String name) {
        this.name = name;
        return this;
    }

    @Override
    public NBTWriter beginObject() {
        return this.begin((INBT)new CompoundNBT());
    }

    @Override
    public NBTWriter endObject() {
        this.context = this.context.parent;
        return this;
    }

    @Override
    public NBTWriter beginArray() {
        return this.begin((INBT)new ListNBT());
    }

    @Override
    public NBTWriter endArray() {
        this.context = this.context.parent;
        return this;
    }

    @Override
    public NBTWriter value(String value) {
        return this.append((INBT)StringNBT.func_229705_a_((String)value));
    }

    @Override
    public NBTWriter value(float value) {
        return this.append((INBT)FloatNBT.func_229689_a_((float)value));
    }

    @Override
    public NBTWriter value(int value) {
        return this.append((INBT)IntNBT.func_229692_a_((int)value));
    }

    private static class Context {
        private final Context parent;
        private INBT value;

        private Context(Context root) {
            this.parent = root;
        }
    }
}

