/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.gui.element;

import com.terraforged.mod.gui.element.Element;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.gui.widget.button.Button;

public class TerraButton
extends Button
implements Element {
    private final List<String> tooltip;

    public TerraButton(String displayString) {
        super(0, 0, 200, 20, displayString, b -> {});
        this.tooltip = Collections.emptyList();
    }

    public TerraButton(String displayString, String ... tooltip) {
        super(0, 0, 200, 20, displayString, b -> {});
        this.tooltip = Arrays.asList(tooltip);
    }

    public TerraButton init(int x, int y, int width, int height) {
        this.x = x;
        this.y = y;
        this.setWidth(width);
        this.setHeight(height);
        return this;
    }

    @Override
    public List<String> getTooltip() {
        return this.tooltip;
    }

    public static TerraButton create(String title, int x, int y, int width, int height, final String tooltip, final Runnable action) {
        TerraButton button = new TerraButton(title){
            private final List<String> tooltips;
            {
                super(displayString);
                this.tooltips = Collections.singletonList(tooltip);
            }

            @Override
            public List<String> getTooltip() {
                return this.tooltips;
            }

            public void onClick(double mouseX, double mouseY) {
                super.onClick(mouseX, mouseY);
                action.run();
            }
        };
        button.x = x;
        button.y = y;
        button.setWidth(width);
        button.setHeight(height);
        return button;
    }
}

