/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.gui;

import com.terraforged.mod.gui.OverlayRenderer;
import com.terraforged.mod.gui.element.CheckBox;
import com.terraforged.mod.gui.element.Element;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class OverlayScreen
extends Screen
implements OverlayRenderer {
    public boolean showTooltips = false;

    public OverlayScreen() {
        super((ITextComponent)new TranslationTextComponent("", new Object[0]));
        this.minecraft = Minecraft.func_71410_x();
        this.font = this.minecraft.field_71466_p;
    }

    public <T extends Widget> T addButton(T buttonIn) {
        return (T)super.addButton(buttonIn);
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        super.render(mouseX, mouseY, partialTicks);
        if (this.showTooltips) {
            this.renderOverlays(this, mouseX, mouseY);
        }
    }

    @Override
    public void renderOverlays(Screen screen, int mouseX, int mouseY) {
        for (Widget button : this.buttons) {
            if (!button.isMouseOver((double)mouseX, (double)mouseY) || !(button instanceof Element)) continue;
            screen.renderTooltip(((Element)button).getTooltip(), mouseX, mouseY);
            return;
        }
    }

    protected void init() {
        this.addButton(new CheckBox("Tooltips", this.showTooltips){

            @Override
            public void onClick(double mouseX, double mouseY) {
                super.onClick(mouseX, mouseY);
                OverlayScreen.this.showTooltips = this.isChecked();
            }

            @Override
            public void render(int mouseX, int mouseY, float partial) {
                this.x = OverlayScreen.this.width - this.width - 13;
                this.y = 6;
                super.render(mouseX, mouseY, partial);
            }
        });
    }
}

