/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.feature.tree;

import com.mojang.datafixers.types.DynamicOps;
import com.terraforged.mod.Log;
import com.terraforged.mod.feature.tree.SaplingConfig;
import com.terraforged.mod.feature.tree.SaplingFeature;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.util.ResourceLocation;

public class SaplingManager {
    private static final Map<ResourceLocation, SaplingFeature> saplings = new HashMap<ResourceLocation, SaplingFeature>();

    public static SaplingFeature getSapling(ResourceLocation name) {
        return saplings.get(name);
    }

    public static void register(Block block, SaplingConfig config) {
        SaplingManager.register(block.getRegistryName(), config);
    }

    public static <T> void register(ResourceLocation location, T config, DynamicOps<T> ops) {
        SaplingManager.register(location, new SaplingConfig(config, ops));
    }

    public static void register(ResourceLocation location, SaplingConfig config) {
        saplings.put(location, new SaplingFeature(config));
    }

    public static void init() {
        SaplingManager.register(Blocks.field_196674_t, new SaplingConfig().addNormal("terraforged:oak_small", 4).addNormal("terraforged:oak_forest", 3).addNormal("terraforged:oak_large", 2).addGiant("terraforged:oak_huge", 1));
        SaplingManager.register(Blocks.field_196676_v, new SaplingConfig().addNormal("terraforged:birch_small", 4).addNormal("terraforged:birch_forest", 3).addNormal("terraforged:birch_large", 1));
        SaplingManager.register(Blocks.field_196678_w, new SaplingConfig().addNormal("terraforged:jungle_small", 4).addGiant("terraforged:jungle_large", 1));
        SaplingManager.register(Blocks.field_196675_u, new SaplingConfig().addNormal("terraforged:spruce_small", 4).addNormal("terraforged:spruce_large", 1).addGiant("terraforged:redwood_huge", 1));
        SaplingManager.register(Blocks.field_196680_y, new SaplingConfig().addNormal("terraforged:dark_oak_small", 4).addNormal("terraforged:dark_oak_large", 1));
        SaplingManager.register(Blocks.field_196679_x, new SaplingConfig().addNormal("terraforged:acacia_small", 2).addNormal("terraforged:acacia_large", 1));
        Log.info("Registered saplings", new Object[0]);
    }
}

