/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.feature.predicate;

import com.terraforged.core.world.climate.Climate;
import com.terraforged.feature.predicate.FeaturePredicate;
import com.terraforged.mod.chunk.TerraContext;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.Heightmap;

public class TreeLine
implements FeaturePredicate {
    private final int worldHeight;
    private final Climate climate;

    public TreeLine(TerraContext context) {
        this.worldHeight = context.levels.worldHeight;
        this.climate = context.heightmap.getClimate();
    }

    @Override
    public boolean test(IChunk chunk, Biome biome) {
        int x = chunk.func_76632_l().func_180334_c() + 8;
        int z = chunk.func_76632_l().func_180333_d() + 8;
        int treeline = this.getTreeline(x, z);
        int y = chunk.func_201576_a(Heightmap.Type.WORLD_SURFACE_WG, 8, 8);
        return y < treeline;
    }

    private int getTreeline(int x, int z) {
        return (int)(this.climate.getTreeLine(x, z) * (float)this.worldHeight);
    }
}

