/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.decorator.surface;

import com.terraforged.api.chunk.surface.Surface;
import com.terraforged.api.chunk.surface.SurfaceContext;
import com.terraforged.api.material.state.States;
import com.terraforged.core.cell.Cell;
import com.terraforged.core.world.heightmap.Levels;
import com.terraforged.mod.chunk.TerraContext;
import me.dags.noise.Module;
import me.dags.noise.Source;
import me.dags.noise.util.NoiseUtil;
import net.minecraft.block.BlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilder;

public class FrozenOcean
implements Surface {
    private final Module up;
    private final Module down;
    private final Module fadeUp;
    private final Module bergTop;
    private final Module seaFloor;
    private final Levels levels;
    private final float minDepth;
    private final float depthRange;

    public FrozenOcean(TerraContext context, int height, int depth) {
        Levels levels = context.levels;
        Module shape = Source.perlin(context.seed.next(), 65, 3).warp(context.seed.next(), 15, 1, 10.0).cache();
        Module mask = shape.threshold(0.6).cache();
        Module fadeDown = shape.clamp(0.6, 0.725).map(0.0, 1.0);
        this.levels = levels;
        this.fadeUp = shape.clamp(0.6, 0.65).map(0.0, 1.0);
        this.up = Source.ridge(context.seed.next(), 50, 3).mult(mask).mult(this.fadeUp).scale(levels.scale(height));
        this.down = Source.ridge(context.seed.next(), 60, 3).mult(mask).mult(fadeDown).scale(levels.scale(depth));
        this.bergTop = Source.perlin(context.seed.next(), 25, 2).scale(levels.scale(3)).bias(levels.scale(2));
        this.seaFloor = Source.perlin(context.seed.next(), 50, 1).scale(levels.scale(3)).bias(levels.scale(1));
        this.minDepth = levels.water(-3);
        this.depthRange = levels.scale(7);
    }

    @Override
    public void buildSurface(int x, int z, int height, SurfaceContext ctx) {
        float alpha = this.alpha(ctx.cell);
        int center = this.levels.waterLevel - 5;
        int top = center + (int)(this.up.getValue(x, z) * (float)this.levels.worldHeight * alpha);
        int topDepth = (int)(this.bergTop.getValue(x, z) * (float)this.levels.worldHeight * alpha);
        int bottom = center - (int)(this.down.getValue(x, z) * (float)this.levels.worldHeight * alpha);
        BlockPos.Mutable pos = new BlockPos.Mutable(x, height, z);
        for (int dy = top; dy > bottom; --dy) {
            pos.func_185336_p(dy);
            BlockState state = this.getMaterial(x, dy, z, top, topDepth);
            ctx.chunk.func_177436_a((BlockPos)pos, state, false);
        }
        int floorBed = ctx.levels.scale(ctx.cell.value);
        int floorDepth = (int)(this.seaFloor.getValue(x, z) * (float)this.levels.worldHeight);
        for (int dy = 0; dy < floorDepth; ++dy) {
            pos.func_185336_p(floorBed - dy);
            ctx.chunk.func_177436_a((BlockPos)pos, SurfaceBuilder.field_215413_j, false);
        }
    }

    private BlockState getMaterial(int x, int y, int z, int top, int topDepth) {
        if (y >= top - topDepth && this.fadeUp.getValue(x, z) == 1.0f) {
            return (BlockState)States.SNOW_BLOCK.get();
        }
        return (BlockState)States.PACKED_ICE.get();
    }

    private float alpha(Cell<?> cell) {
        if (cell.value > this.minDepth) {
            return 0.0f;
        }
        float alpha = 1.0f;
        float delta = this.minDepth - cell.value;
        if (delta < this.depthRange) {
            alpha -= (this.depthRange - delta) / this.depthRange;
        }
        return NoiseUtil.clamp(alpha *= NoiseUtil.map(cell.riverMask, 0.3f, 1.0f, 0.7f), 0.0f, 1.0f);
    }
}

