/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.data;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.Dynamic;
import com.mojang.datafixers.types.DynamicOps;
import com.mojang.datafixers.types.JsonOps;
import com.terraforged.mod.data.DataGen;
import java.io.File;
import java.io.Writer;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.jigsaw.JigsawManager;
import net.minecraft.world.gen.feature.jigsaw.JigsawPattern;
import net.minecraft.world.gen.feature.jigsaw.JigsawPatternRegistry;
import net.minecraft.world.gen.feature.jigsaw.JigsawPiece;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraftforge.registries.ForgeRegistries;

public class WorldGenFeatures
extends DataGen {
    public static void genBiomeFeatures(File dataDir) {
        if (dataDir.exists() || dataDir.mkdirs()) {
            for (Biome biome : ForgeRegistries.BIOMES) {
                WorldGenFeatures.genBiomeFeatures(dataDir, biome);
                WorldGenFeatures.genBiomeStructures(dataDir, biome);
            }
            WorldGenFeatures.genBiomeJigsaws(dataDir);
        }
    }

    private static void genBiomeFeatures(File dir, Biome biome) {
        WorldGenFeatures.write(new File(dir, WorldGenFeatures.getJsonPath("features", biome.getRegistryName())), (Writer writer) -> {
            JsonObject root = new JsonObject();
            for (GenerationStage.Decoration type : GenerationStage.Decoration.values()) {
                JsonArray features = new JsonArray();
                for (ConfiguredFeature feature : biome.func_203607_a(type)) {
                    try {
                        Dynamic dynamic = feature.func_222735_a((DynamicOps)JsonOps.INSTANCE);
                        features.add((JsonElement)dynamic.getValue());
                    }
                    catch (NullPointerException e) {
                        new NullPointerException("Badly written feature: " + feature.field_222737_a.getRegistryName()).printStackTrace();
                    }
                }
                root.add(type.func_222676_a(), (JsonElement)features);
            }
            WorldGenFeatures.write((JsonElement)root, writer);
        });
    }

    private static void genBiomeStructures(File dir, Biome biome) {
        WorldGenFeatures.write(new File(dir, WorldGenFeatures.getJsonPath("structures", biome.getRegistryName())), (Writer writer) -> {
            JsonObject root = new JsonObject();
            for (Map.Entry e : Structure.field_202300_at.entrySet()) {
                JsonArray array = new JsonArray();
                IFeatureConfig config = biome.func_201857_b((Structure)e.getValue());
                if (config == null) continue;
                JsonElement element = (JsonElement)config.func_214634_a((DynamicOps)JsonOps.INSTANCE).getValue();
                JsonObject object = new JsonObject();
                object.addProperty("structure", ((Structure)e.getValue()).getRegistryName() + "");
                object.add("config", element);
                array.add((JsonElement)object);
            }
            WorldGenFeatures.write((JsonElement)root, writer);
        });
    }

    private static void genBiomeJigsaws(File dir) {
        Random random = new Random();
        WorldGenFeatures.write(new File(dir, "jigsaws.json"), (Writer writer) -> {
            JsonObject root = new JsonObject();
            for (Map.Entry<ResourceLocation, JigsawPattern> e : WorldGenFeatures.getJigsawRegistry().entrySet()) {
                JsonArray array = new JsonArray();
                List pieces = e.getValue().func_214943_b(random);
                for (JigsawPiece piece : pieces) {
                    JsonElement element = (JsonElement)piece.func_214847_b((DynamicOps)JsonOps.INSTANCE).getValue();
                    array.add(element);
                }
                root.add(e.getKey().toString(), (JsonElement)array);
            }
            WorldGenFeatures.write((JsonElement)root, writer);
        });
    }

    private static Map<ResourceLocation, JigsawPattern> getJigsawRegistry() {
        try {
            for (Field field : JigsawPatternRegistry.class.getDeclaredFields()) {
                if (field.getType() != Map.class) continue;
                field.setAccessible(true);
                Object value = field.get(JigsawManager.field_214891_a);
                return (Map)value;
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return Collections.emptyMap();
    }
}

