/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.biome.provider;

import java.util.Collection;
import java.util.LinkedList;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.registries.ForgeRegistries;

public class TerraBiomeRegistry {
    private static final TerraBiomeRegistry instance = new TerraBiomeRegistry();

    public Optional<Biome> getBiome(ResourceLocation name) {
        if (ForgeRegistries.BIOMES.containsKey(name)) {
            return Optional.ofNullable(ForgeRegistries.BIOMES.getValue(name));
        }
        return Optional.empty();
    }

    public Collection<Biome> getAll(Predicate<Biome> filter) {
        LinkedList<Biome> combined = new LinkedList<Biome>(ForgeRegistries.BIOMES.getValues());
        combined.removeIf(filter);
        return combined;
    }

    public static TerraBiomeRegistry getInstance() {
        return instance;
    }
}

