/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.feature.util;

import com.mojang.datafixers.types.DynamicOps;
import com.mojang.datafixers.types.JsonOps;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.ConfiguredRandomFeatureList;
import net.minecraft.world.gen.feature.DecoratedFeatureConfig;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.MultipleRandomFeatureConfig;
import net.minecraft.world.gen.feature.MultipleWithChanceRandomFeatureConfig;
import net.minecraft.world.gen.feature.SingleRandomFeature;
import net.minecraft.world.gen.feature.TwoFeatureChoiceConfig;
import net.minecraft.world.gen.placement.ConfiguredPlacement;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class FeatureDebugger {
    public static List<String> getErrors(ConfiguredFeature<?, ?> feature) {
        ArrayList<String> errors = new ArrayList<String>();
        try {
            FeatureDebugger.checkConfiguredFeature(feature, errors);
        }
        catch (Throwable t) {
            errors.add("Exception thrown whilst debugging biome feature: " + feature + " (this is bad)\nError message:\n" + t.getMessage());
        }
        return errors;
    }

    private static void checkConfiguredFeature(ConfiguredFeature<?, ?> feature, List<String> errors) {
        if (!FeatureDebugger.isValid(feature, errors)) {
            return;
        }
        if (feature.field_222738_b instanceof DecoratedFeatureConfig) {
            FeatureDebugger.decorated((DecoratedFeatureConfig)feature.field_222738_b, errors);
            return;
        }
        if (feature.field_222738_b instanceof SingleRandomFeature) {
            FeatureDebugger.single((SingleRandomFeature)feature.field_222738_b, errors);
            return;
        }
        if (feature.field_222738_b instanceof TwoFeatureChoiceConfig) {
            FeatureDebugger.twoChoice((TwoFeatureChoiceConfig)feature.field_222738_b, errors);
            return;
        }
        if (feature.field_222738_b instanceof MultipleRandomFeatureConfig) {
            FeatureDebugger.multi((MultipleRandomFeatureConfig)feature.field_222738_b, errors);
            return;
        }
        if (feature.field_222738_b instanceof MultipleWithChanceRandomFeatureConfig) {
            FeatureDebugger.multiChance((MultipleWithChanceRandomFeatureConfig)feature.field_222738_b, errors);
            return;
        }
    }

    private static void decorated(DecoratedFeatureConfig config, List<String> errors) {
        FeatureDebugger.checkConfiguredFeature(config.field_214689_a, errors);
        FeatureDebugger.isValid(config.field_214690_b, errors);
    }

    private static void single(SingleRandomFeature config, List<String> errors) {
        for (ConfiguredFeature feature : config.field_204628_a) {
            FeatureDebugger.checkConfiguredFeature(feature, errors);
        }
    }

    private static void twoChoice(TwoFeatureChoiceConfig config, List<String> errors) {
        FeatureDebugger.checkConfiguredFeature(config.field_227285_a_, errors);
        FeatureDebugger.checkConfiguredFeature(config.field_227286_b_, errors);
    }

    private static void multi(MultipleRandomFeatureConfig config, List<String> errors) {
        for (ConfiguredRandomFeatureList feature : config.field_202449_a) {
            FeatureDebugger.checkConfiguredFeature(feature.field_214842_a, errors);
        }
    }

    private static void multiChance(MultipleWithChanceRandomFeatureConfig config, List<String> errors) {
        for (ConfiguredFeature feature : config.field_202454_a) {
            FeatureDebugger.checkConfiguredFeature(feature, errors);
        }
    }

    private static boolean isValid(ConfiguredFeature<?, ?> feature, List<String> list) {
        if (feature == null) {
            list.add("null configured feature (this is bad! D: )");
            return false;
        }
        return FeatureDebugger.isValid(feature.field_222737_a, list) && FeatureDebugger.isValid(feature.field_222738_b, list);
    }

    private static boolean isValid(Feature<?> feature, List<String> list) {
        if (feature == null) {
            list.add("null feature");
            return false;
        }
        if (!ForgeRegistries.FEATURES.containsValue(feature)) {
            list.add("unregistered feature: " + feature.getClass().getName());
            return false;
        }
        return true;
    }

    private static boolean isValid(IFeatureConfig config, List<String> list) {
        if (config == null) {
            list.add("null config");
            return false;
        }
        try {
            config.func_214634_a((DynamicOps)JsonOps.INSTANCE);
            return true;
        }
        catch (Throwable t) {
            list.add("config: " + config.getClass().getName() + ", error: " + t.getMessage());
            return false;
        }
    }

    private static boolean isValid(ConfiguredPlacement<?> decorator, List<String> list) {
        if (decorator == null) {
            list.add("null configured placement");
            return false;
        }
        boolean valid = true;
        if (decorator.field_215096_a == null) {
            list.add("null placement");
            valid = false;
        } else if (!ForgeRegistries.DECORATORS.containsValue((IForgeRegistryEntry)decorator.field_215096_a)) {
            list.add("unregistered placement: " + decorator.field_215096_a.getClass().getName());
            valid = false;
        }
        if (decorator.field_215097_b == null) {
            list.add("null decorator config");
            valid = false;
        } else {
            try {
                decorator.field_215097_b.func_214719_a((DynamicOps)JsonOps.INSTANCE);
            }
            catch (Throwable t) {
                valid = false;
                list.add("placement config: " + decorator.field_215097_b.getClass().getName() + ", error: " + t.getMessage());
            }
        }
        return valid;
    }
}

