/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.feature.template.feature;

import com.terraforged.feature.template.feature.TemplateFeatureConfig;
import com.terraforged.feature.util.BlockReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.template.Template;

public class TemplateFeature
extends Feature<TemplateFeatureConfig> {
    private final List<BlockInfo> blocks;

    private TemplateFeature(List<BlockInfo> blocks) {
        super(TemplateFeatureConfig::deserialize);
        this.blocks = blocks;
    }

    public boolean place(IWorld world, ChunkGenerator<?> generator, Random rand, BlockPos origin, TemplateFeatureConfig config) {
        Mirror mirror = TemplateFeature.getMirror(rand);
        Rotation rotation = TemplateFeature.getRotation(rand);
        BlockReader reader = new BlockReader();
        boolean placed = false;
        for (BlockInfo block : this.blocks) {
            BlockState current;
            BlockState state = block.state.func_185907_a(rotation).func_185902_a(mirror);
            if (TemplateFeature.isAir(state) && !config.pasteAir) continue;
            BlockPos pos = Template.func_207669_a((BlockPos)block.pos, (Mirror)mirror, (Rotation)rotation, (BlockPos)BlockPos.field_177992_a).func_177971_a((Vec3i)origin);
            if (block.pos.func_177956_o() <= 0 && block.state.func_215686_e((IBlockReader)reader.setState(block.state), BlockPos.field_177992_a)) {
                this.placeBase(world, pos, state, config.baseDepth);
            }
            if (!config.replaceSolid && (current = world.func_180495_p(pos)).func_200132_m()) continue;
            placed = true;
            world.func_180501_a(pos, state, 2);
        }
        return placed;
    }

    private void placeBase(IWorld world, BlockPos pos, BlockState state, int depth) {
        for (int dy = 0; dy < depth; ++dy) {
            if (world.func_180495_p(pos = pos.func_177977_b()).func_200132_m()) {
                return;
            }
            world.func_180501_a(pos, state, 2);
        }
    }

    private static boolean isAir(BlockState state) {
        return state.func_177230_c() == Blocks.field_150350_a;
    }

    private static Mirror getMirror(Random random) {
        return Mirror.values()[random.nextInt(Mirror.values().length)];
    }

    private static Rotation getRotation(Random random) {
        return Rotation.values()[random.nextInt(Rotation.values().length)];
    }

    public static Optional<TemplateFeature> load(InputStream data) {
        try {
            CompoundNBT root = CompressedStreamTools.func_74796_a((InputStream)data);
            if (!root.func_74764_b("palette") || !root.func_74764_b("blocks")) {
                return Optional.empty();
            }
            BlockState[] palette = TemplateFeature.readPalette(root.func_150295_c("palette", 10));
            BlockInfo[] blockInfos = TemplateFeature.readBlocks(root.func_150295_c("blocks", 10), palette);
            List<BlockInfo> blocks = TemplateFeature.relativize(blockInfos);
            return Optional.of(new TemplateFeature(blocks));
        }
        catch (IOException e) {
            return Optional.empty();
        }
    }

    private static BlockState[] readPalette(ListNBT list) {
        BlockState[] palette = new BlockState[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            try {
                palette[i] = NBTUtil.func_190008_d((CompoundNBT)list.func_150305_b(i));
                continue;
            }
            catch (Throwable t) {
                palette[i] = Blocks.field_150350_a.func_176223_P();
            }
        }
        return palette;
    }

    private static BlockInfo[] readBlocks(ListNBT list, BlockState[] palette) {
        BlockInfo[] blocks = new BlockInfo[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            CompoundNBT compound = list.func_150305_b(i);
            BlockState state = palette[compound.func_74762_e("state")];
            BlockPos pos = TemplateFeature.readPos(compound.func_150295_c("pos", 3));
            blocks[i] = new BlockInfo(pos, state);
        }
        return blocks;
    }

    private static List<BlockInfo> relativize(BlockInfo[] blocks) {
        int minX = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int minZ = Integer.MAX_VALUE;
        int maxZ = Integer.MIN_VALUE;
        for (BlockInfo block : blocks) {
            minX = Math.min(minX, block.pos.func_177958_n());
            maxX = Math.max(maxX, block.pos.func_177958_n());
            minZ = Math.min(minZ, block.pos.func_177952_p());
            maxZ = Math.max(maxZ, block.pos.func_177952_p());
        }
        int width = maxX - minX;
        int length = maxZ - minZ;
        int centerX = width / 2;
        int centerZ = length / 2;
        BlockPos origin = null;
        int lowestSolid = Integer.MAX_VALUE;
        int closestDist2 = Integer.MAX_VALUE;
        for (BlockInfo block : blocks) {
            int dist2;
            if (!block.state.func_200132_m()) continue;
            if (origin == null) {
                origin = block.pos;
                lowestSolid = block.pos.func_177956_o();
                closestDist2 = TemplateFeature.dist2(centerX, centerZ, block.pos.func_177958_n(), block.pos.func_177952_p());
                continue;
            }
            if (block.pos.func_177956_o() < lowestSolid) {
                origin = block.pos;
                lowestSolid = block.pos.func_177956_o();
                closestDist2 = TemplateFeature.dist2(centerX, centerZ, block.pos.func_177958_n(), block.pos.func_177952_p());
                continue;
            }
            if (block.pos.func_177956_o() != lowestSolid || (dist2 = TemplateFeature.dist2(centerX, centerZ, block.pos.func_177958_n(), block.pos.func_177952_p())) >= closestDist2) continue;
            origin = block.pos;
            closestDist2 = dist2;
            lowestSolid = block.pos.func_177956_o();
        }
        if (origin == null) {
            return Arrays.asList(blocks);
        }
        ArrayList<BlockInfo> list = new ArrayList<BlockInfo>(blocks.length);
        for (BlockInfo in : blocks) {
            BlockPos pos = in.pos.func_177973_b((Vec3i)origin);
            BlockInfo out = new BlockInfo(pos, in.state);
            list.add(out);
        }
        return list;
    }

    private static int dist2(int x1, int z1, int x2, int z2) {
        int dx = x1 - x2;
        int dz = z1 - z2;
        return dx * dx + dz * dz;
    }

    private static BlockPos readPos(ListNBT list) {
        int x = list.func_186858_c(0);
        int y = list.func_186858_c(1);
        int z = list.func_186858_c(2);
        return new BlockPos(x, y, z);
    }

    public static class BlockInfo {
        private final BlockPos pos;
        private final BlockState state;

        public BlockInfo(BlockPos pos, BlockState state) {
            this.pos = pos;
            this.state = state;
        }

        public BlockPos getPos() {
            return this.pos;
        }

        public BlockState getState() {
            return this.state;
        }

        public String toString() {
            return this.state.toString();
        }
    }
}

