/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.feature.template.feature;

import com.terraforged.feature.template.TemplateConfig;
import com.terraforged.feature.template.feature.TemplateFeature;
import com.terraforged.feature.template.feature.TemplateFeatureConfig;
import com.terraforged.feature.template.type.FeatureType;
import com.terraforged.feature.template.type.TypedFeature;
import java.util.List;
import java.util.Random;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.NoFeatureConfig;

public class MultiTemplateFeature
extends Feature<NoFeatureConfig>
implements TypedFeature {
    private final int baseDepth;
    private final FeatureType type;
    private final ResourceLocation name;
    private final List<TemplateFeature> templates;

    public MultiTemplateFeature(TemplateConfig config, List<TemplateFeature> templates) {
        super(NoFeatureConfig::func_214639_a);
        this.type = config.getType();
        this.name = config.getRegistryName();
        this.baseDepth = config.getBaseDepth();
        this.templates = templates;
        this.setRegistryName(this.name);
    }

    @Override
    public FeatureType getType() {
        return this.type;
    }

    public boolean place(IWorld world, ChunkGenerator<?> generator, Random rand, BlockPos pos, NoFeatureConfig config) {
        if (this.getType().getPlacement().canPlaceAt((IWorldGenerationReader)world, pos) && this.templates.size() > 0) {
            TemplateFeature feature = this.next(rand);
            TemplateFeatureConfig cfg = new TemplateFeatureConfig(false, false, this.baseDepth);
            return feature.func_212245_a(world, generator, rand, pos, (IFeatureConfig)cfg);
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MultiTemplateFeature that = (MultiTemplateFeature)o;
        return this.name.equals((Object)that.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    private TemplateFeature next(Random random) {
        int index = random.nextInt(this.templates.size());
        return this.templates.get(index);
    }
}

