/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.feature.template.decorator.tree;

import com.google.gson.JsonElement;
import com.mojang.datafixers.Dynamic;
import com.mojang.datafixers.types.DynamicOps;
import com.mojang.datafixers.types.JsonOps;
import com.terraforged.feature.template.decorator.DecoratedFeature;
import com.terraforged.feature.template.decorator.DecoratorFactory;
import com.terraforged.feature.template.decorator.tree.TreeBuffer;
import com.terraforged.feature.template.decorator.tree.TreeFeatureDecorator;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.treedecorator.TreeDecorator;

public class TreeDecoratorFactory
implements DecoratorFactory {
    public static final TreeDecoratorFactory INSTANCE = new TreeDecoratorFactory();
    private static final Function<IWorld, TreeBuffer> FACTORY = w -> {
        if (w instanceof TreeBuffer) {
            return (TreeBuffer)w;
        }
        return new TreeBuffer((IWorld)w);
    };

    @Override
    public <T extends Feature<NoFeatureConfig>> Optional<DecoratedFeature<?, ?>> apply(T feature, JsonElement decorators) {
        if (!decorators.isJsonObject()) {
            return Optional.empty();
        }
        ArrayList list = new ArrayList();
        for (Map.Entry entry : decorators.getAsJsonObject().entrySet()) {
            if (!((JsonElement)entry.getValue()).isJsonObject()) continue;
            Registry.field_229390_w_.func_218349_b(new ResourceLocation((String)entry.getKey())).ifPresent(type -> {
                Dynamic dynamic = new Dynamic((DynamicOps)JsonOps.INSTANCE, entry.getValue());
                TreeDecorator decorator = type.func_227431_a_(dynamic);
                list.add(new TreeFeatureDecorator(decorator));
            });
        }
        if (list.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new DecoratedFeature<T, TreeBuffer>(feature, list, FACTORY));
    }
}

