/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.feature.template;

import com.terraforged.feature.FeatureManager;
import com.terraforged.feature.data.DataHelper;
import com.terraforged.feature.data.DataPack;
import com.terraforged.feature.template.TemplateConfig;
import com.terraforged.feature.template.decorator.DecoratedFeature;
import com.terraforged.feature.template.decorator.DecoratorFactory;
import com.terraforged.feature.template.feature.MultiTemplateFeature;
import com.terraforged.feature.template.feature.TemplateFeature;
import com.terraforged.feature.template.type.FeatureTypes;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.gen.feature.Feature;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public class TemplateManager {
    private static final Marker marker = MarkerManager.getMarker((String)"TEMPLATES");

    public static void register(RegistryEvent.Register<Feature<?>> event) {
        String modid = ModLoadingContext.get().getActiveContainer().getModId();
        TemplateManager.register(modid, event);
    }

    public static void register(String modid, RegistryEvent.Register<Feature<?>> event) {
        DataPack.getModDataPack(modid).ifPresent(dataPack -> {
            List<TemplateConfig> configs = TemplateManager.loadConfigs(dataPack);
            for (TemplateConfig config : configs) {
                FeatureManager.LOG.debug(marker, "Registering feature: {}", (Object)config.getRegistryName());
                List<TemplateFeature> templates = TemplateManager.loadTemplates(dataPack, config);
                MultiTemplateFeature feature = new MultiTemplateFeature(config, templates);
                DecoratorFactory factory = feature.getType().getFactory();
                Optional<DecoratedFeature<?, ?>> decorated = factory.apply(feature, config.getDecorators());
                if (decorated.isPresent()) {
                    event.getRegistry().register((IForgeRegistryEntry)decorated.get());
                    FeatureTypes.register(feature.getType(), (Feature)decorated.get());
                    continue;
                }
                event.getRegistry().register((IForgeRegistryEntry)feature);
                FeatureTypes.register(feature.getType(), feature);
            }
        });
    }

    private static List<TemplateConfig> loadConfigs(DataPack pack) {
        ArrayList<TemplateConfig> list = new ArrayList<TemplateConfig>();
        pack.iterateJson("templates", (location, element) -> {
            Optional<TemplateConfig> config = TemplateConfig.parse(location, element);
            if (config.isPresent()) {
                list.add(config.get());
                FeatureManager.LOG.debug(marker, " Loaded template config: {}", (Object)location);
            } else {
                FeatureManager.LOG.error(marker, " Failed to load template config: {}", (Object)location);
            }
        });
        return list;
    }

    private static List<TemplateFeature> loadTemplates(DataPack pack, TemplateConfig config) {
        ArrayList<TemplateFeature> list = new ArrayList<TemplateFeature>();
        for (ResourceLocation path : config.getPaths()) {
            FeatureManager.LOG.debug(marker, " Loading templates for: {}", (Object)config.getRegistryName());
            pack.iterateData(path.func_110623_a(), DataHelper.NBT, (location, data) -> {
                Optional<TemplateFeature> template = TemplateFeature.load(data);
                if (template.isPresent()) {
                    list.add(template.get());
                    FeatureManager.LOG.debug(marker, "  Loaded template: {}", (Object)location);
                } else {
                    FeatureManager.LOG.error(marker, "  Failed to load template: {}", (Object)location);
                }
            });
        }
        return list;
    }
}

