/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.feature.modifier;

import com.terraforged.feature.matcher.BiomeFeatureMatcher;
import com.terraforged.feature.matcher.biome.BiomeMatcher;
import com.terraforged.feature.matcher.feature.FeatureMatcher;
import com.terraforged.feature.modifier.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class ModifierList<T>
implements Iterable<Modifier<T>> {
    private List<Modifier<T>> list = Collections.emptyList();

    public int size() {
        return this.list.size();
    }

    public void sort() {
        Collections.sort(this.list);
    }

    @Override
    public Iterator<Modifier<T>> iterator() {
        return this.list.iterator();
    }

    public void add(FeatureMatcher featureMatcher, T modifier) {
        this.add(BiomeMatcher.ANY, featureMatcher, modifier);
    }

    public void add(BiomeMatcher biomeMatcher, FeatureMatcher featureMatcher, T modifier) {
        BiomeFeatureMatcher matcher = new BiomeFeatureMatcher(biomeMatcher, featureMatcher);
        this.add(matcher, modifier);
    }

    public void add(BiomeFeatureMatcher matcher, T modifier) {
        if (this.list.isEmpty()) {
            this.list = new ArrayList<Modifier<T>>();
        }
        this.list.add(new Modifier<T>(matcher, modifier));
    }
}

