/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.core.world.terrain;

import com.terraforged.core.cell.Cell;
import com.terraforged.core.cell.Populator;
import com.terraforged.core.world.terrain.Terrain;
import me.dags.noise.Module;

public class TerrainPopulator
implements Populator {
    private final Terrain type;
    private final Module source;

    public TerrainPopulator(Module source, Terrain type) {
        this.type = type;
        this.source = TerrainPopulator.clamp(source);
    }

    public Module getSource() {
        return this.source;
    }

    public Terrain getType() {
        return this.type;
    }

    @Override
    public void apply(Cell<Terrain> cell, float x, float z) {
        cell.value = this.source.getValue(x, z);
        cell.tag = this.type;
    }

    @Override
    public void tag(Cell<Terrain> cell, float x, float y) {
        cell.tag = this.type;
    }

    public static Module clamp(Module module) {
        if (module.minValue() < 0.0f || module.maxValue() > 1.0f) {
            return module.clamp(0.0, 1.0);
        }
        return module;
    }
}

