/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.core.world.rivermap;

import com.terraforged.core.cell.Cell;
import com.terraforged.core.region.Region;
import com.terraforged.core.util.concurrent.ThreadPool;
import com.terraforged.core.util.concurrent.cache.Cache;
import com.terraforged.core.util.concurrent.cache.CacheEntry;
import com.terraforged.core.world.GeneratorContext;
import com.terraforged.core.world.heightmap.Heightmap;
import com.terraforged.core.world.rivermap.RiverMapConfig;
import com.terraforged.core.world.rivermap.RiverRegionList;
import com.terraforged.core.world.rivermap.lake.LakeConfig;
import com.terraforged.core.world.rivermap.river.RiverConfig;
import com.terraforged.core.world.rivermap.river.RiverRegion;
import com.terraforged.core.world.terrain.Terrain;
import java.util.concurrent.TimeUnit;
import me.dags.noise.util.NoiseUtil;

public class RiverMap {
    private static final int QUAD_SIZE = 2048;
    private final Heightmap heightmap;
    private final GeneratorContext context;
    private final RiverMapConfig riverMapConfig;
    private final Cache<CacheEntry<RiverRegion>> cache;
    private final ThreadPool threadPool = ThreadPool.getPool();

    public RiverMap(Heightmap heightmap, GeneratorContext context) {
        RiverConfig primary = RiverConfig.builder(context.levels).bankHeight(context.settings.rivers.primaryRivers.minBankHeight, context.settings.rivers.primaryRivers.maxBankHeight).bankWidth(context.settings.rivers.primaryRivers.bankWidth).bedWidth(context.settings.rivers.primaryRivers.bedWidth).bedDepth(context.settings.rivers.primaryRivers.bedDepth).fade(context.settings.rivers.primaryRivers.fade).length(2500).main(true).build();
        RiverConfig secondary = RiverConfig.builder(context.levels).bankHeight(context.settings.rivers.secondaryRiver.minBankHeight, context.settings.rivers.secondaryRiver.maxBankHeight).bankWidth(context.settings.rivers.secondaryRiver.bankWidth).bedWidth(context.settings.rivers.secondaryRiver.bedWidth).bedDepth(context.settings.rivers.secondaryRiver.bedDepth).fade(context.settings.rivers.secondaryRiver.fade).length(1000).build();
        RiverConfig tertiary = RiverConfig.builder(context.levels).bankHeight(context.settings.rivers.tertiaryRivers.minBankHeight, context.settings.rivers.tertiaryRivers.maxBankHeight).bankWidth(context.settings.rivers.tertiaryRivers.bankWidth).bedWidth(context.settings.rivers.tertiaryRivers.bedWidth).bedDepth(context.settings.rivers.tertiaryRivers.bedDepth).fade(context.settings.rivers.tertiaryRivers.fade).length(500).build();
        LakeConfig lakes = LakeConfig.of(context.settings.rivers.lake, context.levels);
        this.heightmap = heightmap;
        this.context = context;
        this.riverMapConfig = new RiverMapConfig(context.settings.rivers.riverFrequency, primary, secondary, tertiary, lakes);
        this.cache = new Cache(3L, 1L, TimeUnit.MINUTES);
    }

    public RiverRegionList getRivers(Region region) {
        RiverRegionList rivers = new RiverRegionList();
        this.getRivers(region.getBlockX(), region.getBlockZ(), rivers);
        return rivers;
    }

    public RiverRegionList getRivers(int blockX, int blockZ) {
        RiverRegionList rivers = new RiverRegionList();
        this.getRivers(blockX, blockZ, rivers);
        return rivers;
    }

    public void getRivers(Region region, RiverRegionList rivers) {
        this.getRivers(region.getBlockX(), region.getBlockZ(), rivers);
    }

    public void getRivers(int blockX, int blockZ, RiverRegionList rivers) {
        int rx = RiverRegion.blockToRegion(blockX);
        int rz = RiverRegion.blockToRegion(blockZ);
        int qx = blockX < RiverRegion.regionToBlock(rx) + 2048 ? -1 : 1;
        int qz = blockZ < RiverRegion.regionToBlock(rz) + 2048 ? -1 : 1;
        int minX = Math.min(0, qx);
        int minZ = Math.min(0, qz);
        int maxX = Math.max(0, qx);
        int maxZ = Math.max(0, qz);
        rivers.reset();
        for (int dz = minZ; dz <= maxZ; ++dz) {
            for (int dx = minX; dx <= maxX; ++dx) {
                rivers.add(this.getRegion(rx + dx, rz + dz));
            }
        }
    }

    public void apply(Cell<Terrain> cell, float x, float z) {
        RiverRegionList rivers = new RiverRegionList();
        this.getRivers((int)x, (int)z, rivers);
        rivers.apply(cell, x, z);
    }

    private CacheEntry<RiverRegion> getRegion(int rx, int rz) {
        long id = NoiseUtil.seed(rx, rz);
        return this.cache.computeIfAbsent(id, l -> this.generateRegion(rx, rz));
    }

    private CacheEntry<RiverRegion> generateRegion(int rx, int rz) {
        return CacheEntry.supplyAsync(() -> new RiverRegion(rx, rz, this.heightmap, this.context, this.riverMapConfig), this.threadPool);
    }
}

