/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.core.world.biome;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class BiomeData
implements Comparable<BiomeData> {
    private static float[] bounds = new float[]{0.0f, 0.33333334f, 0.6666667f, 1.0f};
    public static final List<BiomeData> BIOMES = new ArrayList<BiomeData>();
    public static BiomeData DEFAULT = new BiomeData("none", (Object)"", 1, 0.5f, 0.5f);
    public final String name;
    public final Object reference;
    public final float color;
    public final float rainfall;
    public final float temperature;

    public BiomeData(String name, Object reference, float color, float rainfall, float temperature) {
        this.reference = reference;
        this.name = name;
        this.rainfall = rainfall;
        this.temperature = temperature;
        this.color = color;
    }

    public BiomeData(String name, Object reference, int color, float rainfall, float temperature) {
        Color c = new Color(color);
        this.reference = reference;
        this.name = name;
        this.rainfall = rainfall;
        this.temperature = temperature;
        this.color = BiomeData.getHue(c.getRed(), c.getGreen(), c.getBlue());
    }

    @Override
    public int compareTo(BiomeData o) {
        return this.name.compareTo(o.name);
    }

    public static Collection<BiomeData> getBiomes(float temperature, float rainfall) {
        int temp = Math.min(3, (int)((float)bounds.length * temperature));
        int rain = Math.min(3, (int)((float)bounds.length * rainfall));
        return BiomeData.getBiomes(temp, rain);
    }

    public static Collection<BiomeData> getBiomes(int tempLower, int rainLower) {
        int temp0 = tempLower;
        int temp1 = temp0 + 1;
        int rain0 = rainLower;
        int rain1 = rain0 + 1;
        float tempMin = bounds[temp0];
        float tempMax = bounds[temp1];
        float rainMin = bounds[rain0];
        float rainMax = bounds[rain1];
        ArrayList<BiomeData> biomes = new ArrayList<BiomeData>();
        for (BiomeData biome : BIOMES) {
            if (!(biome.temperature >= tempMin) || !(biome.temperature <= tempMax) || !(biome.rainfall >= rainMin) || !(biome.rainfall <= rainMax)) continue;
            biomes.add(biome);
        }
        if (biomes.isEmpty()) {
            biomes.add(DEFAULT);
        }
        return biomes;
    }

    public static Collection<BiomeData> getTempBiomes(float temperature) {
        int lower = Math.min(3, (int)((float)bounds.length * temperature));
        int upper = lower + 1;
        float min = bounds[lower];
        float max = bounds[upper];
        ArrayList<BiomeData> biomes = new ArrayList<BiomeData>();
        for (BiomeData data : BIOMES) {
            if (!(data.temperature >= min) || !(data.temperature <= max)) continue;
            biomes.add(data);
        }
        return biomes;
    }

    public static Collection<BiomeData> getRainBiomes(float rainfall) {
        int lower = Math.min(3, (int)((float)bounds.length * rainfall));
        int upper = lower + 1;
        float min = bounds[lower];
        float max = bounds[upper];
        ArrayList<BiomeData> biomes = new ArrayList<BiomeData>();
        for (BiomeData data : BIOMES) {
            if (!(data.rainfall >= min) || !(data.rainfall <= max)) continue;
            biomes.add(data);
        }
        return biomes;
    }

    private static float getHue(int red, int green, int blue) {
        float max;
        float min = Math.min(Math.min(red, green), blue);
        if (min == (max = (float)Math.max(Math.max(red, green), blue))) {
            return 0.0f;
        }
        float hue = max == (float)red ? (float)(green - blue) / (max - min) : (max == (float)green ? 2.0f + (float)(blue - red) / (max - min) : 4.0f + (float)(red - green) / (max - min));
        if ((hue *= 60.0f) < 0.0f) {
            hue += 360.0f;
        }
        return (float)Math.round(hue) / 360.0f * 100.0f;
    }
}

