/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.core.util.serialization.serializer;

import com.terraforged.core.util.serialization.annotation.Comment;
import com.terraforged.core.util.serialization.annotation.Name;
import com.terraforged.core.util.serialization.annotation.Range;
import com.terraforged.core.util.serialization.annotation.Serializable;
import com.terraforged.core.util.serialization.serializer.Writer;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;

public class Serializer {
    public void serialize(Object object, Writer writer) throws IllegalAccessException {
        if (object.getClass().isArray()) {
            writer.beginArray();
            int length = Array.getLength(object);
            for (int i = 0; i < length; ++i) {
                Object element = Array.get(object, i);
                this.serialize(element, writer);
            }
            writer.endArray();
        } else if (!object.getClass().isPrimitive()) {
            int order = 0;
            writer.beginObject();
            for (Field field : object.getClass().getFields()) {
                if (!Serializer.isSerializable(field)) continue;
                field.setAccessible(true);
                this.write(object, field, order, writer);
                ++order;
            }
            writer.endObject();
        }
    }

    private void write(Object object, Field field, int order, Writer writer) throws IllegalAccessException {
        if (field.getType() == Integer.TYPE) {
            writer.name(field.getName());
            writer.beginObject();
            writer.name("value").value((Integer)field.get(object));
            this.writeMeta(field, order, writer);
            writer.endObject();
            return;
        }
        if (field.getType() == Float.TYPE) {
            writer.name(field.getName());
            writer.beginObject();
            writer.name("value").value(((Float)field.get(object)).floatValue());
            this.writeMeta(field, order, writer);
            writer.endObject();
            return;
        }
        if (field.getType() == String.class) {
            writer.name(field.getName());
            writer.beginObject();
            writer.name("value").value((String)field.get(object));
            this.writeMeta(field, order, writer);
            writer.endObject();
            return;
        }
        if (field.getType() == Boolean.TYPE) {
            writer.name(field.getName());
            writer.beginObject();
            writer.name("value").value("" + field.get(object));
            this.writeMeta(field, order, writer);
            writer.endObject();
        }
        if (field.getType().isEnum()) {
            writer.name(field.getName());
            writer.beginObject();
            writer.name("value").value(((Enum)field.get(object)).name());
            this.writeMeta(field, order, writer);
            writer.endObject();
            return;
        }
        if (field.getType().isArray()) {
            if (field.getType().getComponentType().isAnnotationPresent(Serializable.class)) {
                writer.name(field.getName());
                writer.beginObject();
                writer.name("value");
                this.serialize(field.get(object), writer);
                this.writeMeta(field, order, writer);
                writer.endObject();
            }
            return;
        }
        if (field.getType().isAnnotationPresent(Serializable.class)) {
            writer.name(field.getName());
            writer.beginObject();
            writer.name("value");
            this.serialize(field.get(object), writer);
            this.writeMeta(field, order, writer);
            writer.endObject();
        }
    }

    private void writeMeta(Field field, int order, Writer writer) {
        Comment comment;
        writer.name("#display").value(Serializer.getName(field));
        writer.name("#order").value(order);
        Range range = field.getAnnotation(Range.class);
        if (range != null) {
            if (field.getType() == Integer.TYPE) {
                writer.name("#min").value((int)range.min());
                writer.name("#max").value((int)range.max());
            } else {
                writer.name("#min").value(range.min());
                writer.name("#max").value(range.max());
            }
        }
        if ((comment = field.getAnnotation(Comment.class)) != null) {
            writer.name("#comment");
            writer.beginArray();
            for (String line : comment.value()) {
                writer.value(line);
            }
            writer.endArray();
        }
        if (field.getType() == Boolean.TYPE) {
            writer.name("#options");
            writer.beginArray();
            writer.value("true");
            writer.value("false");
            writer.endArray();
        }
        if (field.getType().isEnum()) {
            writer.name("#options");
            writer.beginArray();
            for (Enum o : field.getType().asSubclass(Enum.class).getEnumConstants()) {
                writer.value(o.name());
            }
            writer.endArray();
        }
    }

    private static String getName(Field field) {
        Name nameMeta = field.getAnnotation(Name.class);
        String name = nameMeta == null ? field.getName() : nameMeta.value();
        StringBuilder sb = new StringBuilder(name.length() * 2);
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (i == 0) {
                c = Character.toUpperCase(c);
            } else if (Character.isUpperCase(c)) {
                sb.append(' ');
            }
            sb.append(c);
        }
        return sb.toString();
    }

    protected static boolean isSerializable(Field field) {
        int modifiers = field.getModifiers();
        return Modifier.isPublic(modifiers) && !Modifier.isFinal(modifiers) && !Modifier.isStatic(modifiers) && !Modifier.isTransient(modifiers);
    }
}

