/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.core.util.concurrent;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;

public class ObjectPool<T> {
    private final int capacity;
    private final List<Item<T>> pool;
    private final Supplier<? extends T> supplier;

    public ObjectPool(int size, Supplier<? extends T> supplier) {
        this.capacity = size;
        this.pool = new ArrayList<Item<T>>(size);
        this.supplier = supplier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Item<T> get() {
        List<Item<T>> list = this.pool;
        synchronized (list) {
            if (this.pool.size() > 0) {
                return ((Item)this.pool.remove(this.pool.size() - 1)).retain();
            }
        }
        return new Item(this.supplier.get(), this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        List<Item<T>> list = this.pool;
        synchronized (list) {
            return this.pool.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean restore(Item<T> item) {
        List<Item<T>> list = this.pool;
        synchronized (list) {
            int size = this.pool.size();
            if (size < this.capacity) {
                this.pool.add(item);
                return true;
            }
        }
        return false;
    }

    public static class Item<T>
    implements AutoCloseable {
        private final T value;
        private final ObjectPool<T> pool;
        private boolean released = false;

        private Item(T value, ObjectPool<T> pool) {
            this.value = value;
            this.pool = pool;
        }

        public T getValue() {
            return this.value;
        }

        public void release() {
            if (!this.released) {
                this.released = true;
                this.released = ((ObjectPool)this.pool).restore(this);
            }
        }

        private Item<T> retain() {
            this.released = false;
            return this;
        }

        @Override
        public void close() {
            this.release();
        }
    }
}

