/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.core.filter;

import com.terraforged.core.cell.Cell;
import com.terraforged.core.filter.Filter;
import com.terraforged.core.filter.Filterable;
import com.terraforged.core.filter.Modifier;
import com.terraforged.core.region.Size;
import com.terraforged.core.settings.Settings;
import com.terraforged.core.world.heightmap.Levels;
import java.util.Random;
import me.dags.noise.util.NoiseUtil;

public class Erosion
implements Filter {
    private int erosionRadius = 3;
    private float inertia = 0.05f;
    private float sedimentCapacityFactor = 4.0f;
    private float minSedimentCapacity = 0.01f;
    private float erodeSpeed = 0.3f;
    private float depositSpeed = 0.3f;
    private float evaporateSpeed = 0.01f;
    private float gravity = 8.0f;
    private int maxDropletLifetime = 30;
    private float initialWaterVolume = 1.0f;
    private float initialSpeed = 1.0f;
    private final TerrainPos gradient = new TerrainPos();
    private int[][] erosionBrushIndices = new int[0][];
    private float[][] erosionBrushWeights = new float[0][];
    private final Modifier modifier;
    private final Random random = new Random();

    public Erosion(Settings settings, Levels levels) {
        this.erodeSpeed = settings.filters.erosion.erosionRate;
        this.depositSpeed = settings.filters.erosion.depositeRate;
        this.modifier = Modifier.range(levels.ground, levels.ground(15));
    }

    @Override
    public void apply(Filterable<?> map, int seedX, int seedZ, int iterations) {
        if (this.erosionBrushIndices.length != map.getSize().total) {
            this.init(map.getSize().total, this.erosionRadius);
        }
        this.applyMain(map, seedX, seedZ, iterations, this.random);
    }

    private int nextCoord(Size size, Random random) {
        return random.nextInt(size.total - 1);
    }

    private void applyMain(Filterable<?> map, int seedX, int seedZ, int iterations, Random random) {
        random.setSeed(NoiseUtil.seed(seedX, seedZ));
        while (iterations-- > 0) {
            int posX = this.nextCoord(map.getSize(), random);
            int posZ = this.nextCoord(map.getSize(), random);
            this.apply(map.getBacking(), (float)posX, (float)posZ, map.getSize().total);
        }
    }

    private void apply(Cell<?>[] cells, float posX, float posY, int size) {
        float dirX = 0.0f;
        float dirY = 0.0f;
        float speed = this.initialSpeed;
        float water = this.initialWaterVolume;
        float sediment = 0.0f;
        for (int lifetime = 0; lifetime < this.maxDropletLifetime; ++lifetime) {
            int nodeX = (int)posX;
            int nodeY = (int)posY;
            int dropletIndex = nodeY * size + nodeX;
            float cellOffsetX = posX - (float)nodeX;
            float cellOffsetY = posY - (float)nodeY;
            this.gradient.update(cells, size, posX, posY);
            dirX = dirX * this.inertia - this.gradient.gradientX * (1.0f - this.inertia);
            dirY = dirY * this.inertia - this.gradient.gradientY * (1.0f - this.inertia);
            float len = (float)Math.sqrt(dirX * dirX + dirY * dirY);
            if (Float.isNaN(len)) {
                len = 0.0f;
            }
            if (len != 0.0f) {
                dirX /= len;
                dirY /= len;
            }
            if (dirX == 0.0f && dirY == 0.0f || (posX += dirX) < 0.0f || posX >= (float)(size - 1) || (posY += dirY) < 0.0f || posY >= (float)(size - 1)) break;
            float oldHeight = this.gradient.height;
            float newHeight = this.gradient.update(cells, size, posX, posY).height;
            float deltaHeight = newHeight - oldHeight;
            float sedimentCapacity = Math.max(-deltaHeight * speed * water * this.sedimentCapacityFactor, this.minSedimentCapacity);
            if (sediment > sedimentCapacity || deltaHeight > 0.0f) {
                float amountToDeposit = deltaHeight > 0.0f ? Math.min(deltaHeight, sediment) : (sediment - sedimentCapacity) * this.depositSpeed;
                sediment -= amountToDeposit;
                this.deposit(cells[dropletIndex], amountToDeposit * (1.0f - cellOffsetX) * (1.0f - cellOffsetY));
                this.deposit(cells[dropletIndex + 1], amountToDeposit * cellOffsetX * (1.0f - cellOffsetY));
                this.deposit(cells[dropletIndex + size], amountToDeposit * (1.0f - cellOffsetX) * cellOffsetY);
                this.deposit(cells[dropletIndex + size + 1], amountToDeposit * cellOffsetX * cellOffsetY);
            } else {
                float amountToErode = Math.min((sedimentCapacity - sediment) * this.erodeSpeed, -deltaHeight);
                for (int brushPointIndex = 0; brushPointIndex < this.erosionBrushIndices[dropletIndex].length; ++brushPointIndex) {
                    int nodeIndex = this.erosionBrushIndices[dropletIndex][brushPointIndex];
                    Cell<?> cell = cells[nodeIndex];
                    float brushWeight = this.erosionBrushWeights[dropletIndex][brushPointIndex];
                    float weighedErodeAmount = amountToErode * brushWeight;
                    float deltaSediment = Math.min(cell.value, weighedErodeAmount);
                    this.erode(cell, deltaSediment);
                    sediment += deltaSediment;
                }
            }
            speed = (float)Math.sqrt(speed * speed + deltaHeight * this.gravity);
            water *= 1.0f - this.evaporateSpeed;
            if (!Float.isNaN(speed)) continue;
            speed = 0.0f;
        }
    }

    private void init(int size, int radius) {
        this.erosionBrushIndices = new int[size * size][];
        this.erosionBrushWeights = new float[size * size][];
        int[] xOffsets = new int[radius * radius * 4];
        int[] yOffsets = new int[radius * radius * 4];
        float[] weights = new float[radius * radius * 4];
        float weightSum = 0.0f;
        int addIndex = 0;
        for (int i = 0; i < this.erosionBrushIndices.length; ++i) {
            int centreX = i % size;
            int centreY = i / size;
            if (centreY <= radius || centreY >= size - radius || centreX <= radius + 1 || centreX >= size - radius) {
                weightSum = 0.0f;
                addIndex = 0;
                for (int y = -radius; y <= radius; ++y) {
                    for (int x = -radius; x <= radius; ++x) {
                        float sqrDst = x * x + y * y;
                        if (!(sqrDst < (float)(radius * radius))) continue;
                        int coordX = centreX + x;
                        int coordY = centreY + y;
                        if (coordX < 0 || coordX >= size || coordY < 0 || coordY >= size) continue;
                        float weight = 1.0f - (float)Math.sqrt(sqrDst) / (float)radius;
                        weightSum += weight;
                        weights[addIndex] = weight;
                        xOffsets[addIndex] = x;
                        yOffsets[addIndex] = y;
                        ++addIndex;
                    }
                }
            }
            int numEntries = addIndex;
            this.erosionBrushIndices[i] = new int[numEntries];
            this.erosionBrushWeights[i] = new float[numEntries];
            for (int j = 0; j < numEntries; ++j) {
                this.erosionBrushIndices[i][j] = (yOffsets[j] + centreY) * size + xOffsets[j] + centreX;
                this.erosionBrushWeights[i][j] = weights[j] / weightSum;
            }
        }
    }

    private void deposit(Cell<?> cell, float amount) {
        float change = this.modifier.modify(cell, amount);
        cell.value += change;
        cell.sediment += change;
    }

    private void erode(Cell<?> cell, float amount) {
        float change = this.modifier.modify(cell, amount);
        cell.value -= change;
        cell.erosion -= change;
    }

    private static class TerrainPos {
        private float height;
        private float gradientX;
        private float gradientY;

        private TerrainPos() {
        }

        private TerrainPos update(Cell<?>[] nodes, int mapSize, float posX, float posY) {
            int coordX = (int)posX;
            int coordY = (int)posY;
            float x = posX - (float)coordX;
            float y = posY - (float)coordY;
            int nodeIndexNW = coordY * mapSize + coordX;
            float heightNW = nodes[nodeIndexNW].value;
            float heightNE = nodes[nodeIndexNW + 1].value;
            float heightSW = nodes[nodeIndexNW + mapSize].value;
            float heightSE = nodes[nodeIndexNW + mapSize + 1].value;
            this.gradientX = (heightNE - heightNW) * (1.0f - y) + (heightSE - heightSW) * y;
            this.gradientY = (heightSW - heightNW) * (1.0f - x) + (heightSE - heightNE) * x;
            this.height = heightNW * (1.0f - x) * (1.0f - y) + heightNE * x * (1.0f - y) + heightSW * (1.0f - x) * y + heightSE * x * y;
            return this;
        }
    }
}

