/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.core.cell;

import com.terraforged.core.cell.Tag;
import com.terraforged.core.util.concurrent.ObjectPool;
import com.terraforged.core.world.biome.BiomeType;
import com.terraforged.core.world.terrain.Terrain;
import me.dags.noise.util.NoiseUtil;

public class Cell<T extends Tag> {
    private static final Cell EMPTY = new Cell(){

        @Override
        public boolean isAbsent() {
            return true;
        }
    };
    private static final ObjectPool<Cell<Terrain>> POOL = new ObjectPool<Cell>(100, Cell::new);
    public float continent;
    public float continentEdge;
    public float region;
    public float regionEdge;
    public float biome;
    public float biomeEdge = 1.0f;
    public float riverMask = 1.0f;
    public float value;
    public float biomeMoisture;
    public float biomeTemperature;
    public float moisture;
    public float temperature;
    public float steepness;
    public float erosion;
    public float sediment;
    public float biomeTypeMask = 1.0f;
    public BiomeType biomeType = BiomeType.GRASSLAND;
    public T tag = null;

    public void copy(Cell<T> other) {
        this.value = other.value;
        this.continent = other.continent;
        this.continentEdge = other.continentEdge;
        this.region = other.region;
        this.regionEdge = other.regionEdge;
        this.biome = other.biome;
        this.biomeEdge = other.biomeEdge;
        this.riverMask = other.riverMask;
        this.moisture = other.moisture;
        this.temperature = other.temperature;
        this.biomeMoisture = other.biomeMoisture;
        this.biomeTemperature = other.biomeTemperature;
        this.steepness = other.steepness;
        this.erosion = other.erosion;
        this.sediment = other.sediment;
        this.biomeType = other.biomeType;
        this.biomeTypeMask = other.biomeTypeMask;
        this.tag = other.tag;
    }

    public float continentMask(float min, float max) {
        return NoiseUtil.map(this.continentEdge, min, max, max - min);
    }

    public float regionMask(float min, float max) {
        return NoiseUtil.map(this.regionEdge, min, max, max - min);
    }

    public float biomeMask(float min, float max) {
        return NoiseUtil.map(this.biomeEdge, min, max, max - min);
    }

    public float mask(float cmin, float cmax, float rmin, float rmax) {
        return this.riverMask * this.continentMask(cmin, cmax) * this.regionMask(rmin, rmax);
    }

    public boolean isAbsent() {
        return false;
    }

    public static <T extends Tag> Cell<T> empty() {
        return EMPTY;
    }

    public static ObjectPool.Item<Cell<Terrain>> pooled() {
        return POOL.get();
    }

    public static interface ZoomVisitor<T extends Tag> {
        public void visit(Cell<T> var1, float var2, float var3);
    }

    public static interface ContextVisitor<C, T extends Tag> {
        public void visit(Cell<T> var1, int var2, int var3, C var4);
    }

    public static interface Visitor<T extends Tag> {
        public void visit(Cell<T> var1, int var2, int var3);
    }
}

