/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.api.chunk.surface;

import com.terraforged.api.chunk.surface.Surface;
import com.terraforged.api.chunk.surface.SurfaceContext;
import com.terraforged.api.chunk.surface.builder.Delegate;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.world.biome.Biome;

public class SurfaceManager {
    private final Map<Biome, Surface> surfaces = new HashMap<Biome, Surface>();

    public SurfaceManager replace(Biome biome, Surface surface) {
        this.surfaces.put(biome, surface);
        return this;
    }

    public SurfaceManager extend(Biome biome, Surface surface) {
        Surface result = this.getOrCreateSurface(biome).then(surface);
        return this.replace(biome, result);
    }

    public Surface getSurface(SurfaceContext context) {
        if (context.biome == context.cached.biome) {
            return context.cached.surface;
        }
        context.cached.biome = context.biome;
        context.cached.surface = this.getOrCreateSurface(context.biome);
        return context.cached.surface;
    }

    public Surface getOrCreateSurface(Biome biome) {
        return this.surfaces.computeIfAbsent(biome, Delegate.FUNC);
    }
}

