/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.api.chunk.column;

import com.terraforged.api.chunk.column.DecoratorContext;
import com.terraforged.api.chunk.surface.ChunkSurfaceBuffer;
import me.dags.noise.Source;
import me.dags.noise.source.FastSource;
import net.minecraft.block.BlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.chunk.IChunk;

public interface ColumnDecorator {
    public static final FastSource variance = (FastSource)Source.perlin(0, 100, 1);

    public void decorate(IChunk var1, DecoratorContext var2, int var3, int var4, int var5);

    default public void decorate(ChunkSurfaceBuffer buffer, DecoratorContext context, int x, int y, int z) {
        this.decorate(buffer.getDelegate(), context, x, y, z);
    }

    default public void setState(IChunk chunk, int x, int y, int z, BlockState state, boolean moving) {
        chunk.func_177436_a(new BlockPos(x, y, z), state, moving);
    }

    default public void fillDown(DecoratorContext context, IChunk chunk, int x, int z, int from, int to, BlockState state) {
        for (int dy = from; dy > to; --dy) {
            chunk.func_177436_a((BlockPos)context.pos.func_181079_c(x, dy, z), state, false);
        }
    }

    public static float getNoise(float x, float z, int seed, float scale, float bias) {
        return variance.getValue(x, z, seed) * scale + bias;
    }

    public static float getNoise(float x, float z, int seed, int scale, int bias) {
        return ColumnDecorator.getNoise(x, z, seed, (float)scale / 255.0f, (float)bias / 255.0f);
    }
}

