/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsbuilder.modules.shield.filters;

import mcjty.lib.varia.Logging;
import mcjty.rftoolsbuilder.modules.shield.filters.AnimalFilter;
import mcjty.rftoolsbuilder.modules.shield.filters.DefaultFilter;
import mcjty.rftoolsbuilder.modules.shield.filters.HostileFilter;
import mcjty.rftoolsbuilder.modules.shield.filters.ItemFilter;
import mcjty.rftoolsbuilder.modules.shield.filters.PlayerFilter;
import mcjty.rftoolsbuilder.modules.shield.filters.ShieldFilter;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;

public abstract class AbstractShieldFilter
implements ShieldFilter {
    private int action = 0;

    @Override
    public int getAction() {
        return this.action;
    }

    @Override
    public void setAction(int action) {
        this.action = action;
    }

    @Override
    public void toBytes(PacketBuffer buf) {
        CompoundNBT tagCompound = new CompoundNBT();
        this.writeToNBT(tagCompound);
        buf.func_150786_a(tagCompound);
    }

    @Override
    public void readFromNBT(CompoundNBT tagCompound) {
        this.action = tagCompound.func_74762_e("action");
    }

    @Override
    public void writeToNBT(CompoundNBT tagCompound) {
        tagCompound.func_74778_a("type", this.getFilterName());
        tagCompound.func_74768_a("action", this.action);
    }

    public static ShieldFilter createFilter(PacketBuffer buf) {
        CompoundNBT compound = buf.func_150793_b();
        return AbstractShieldFilter.createFilter(compound);
    }

    public static ShieldFilter createFilter(CompoundNBT compound) {
        String type = compound.func_74779_i("type");
        ShieldFilter filter = AbstractShieldFilter.createFilter(type);
        filter.readFromNBT(compound);
        return filter;
    }

    public static ShieldFilter createFilter(String type) {
        AbstractShieldFilter filter;
        if ("animal".equals(type)) {
            filter = new AnimalFilter();
        } else if ("hostile".equals(type)) {
            filter = new HostileFilter();
        } else if ("player".equals(type)) {
            filter = new PlayerFilter();
        } else if ("item".equals(type)) {
            filter = new ItemFilter();
        } else if ("default".equals(type)) {
            filter = new DefaultFilter();
        } else {
            Logging.log((String)("Unknown filter type = " + type));
            filter = new DefaultFilter();
        }
        return filter;
    }
}

