/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsbuilder.modules.shield;

import mcjty.lib.blocks.BaseBlock;
import mcjty.lib.container.GenericContainer;
import mcjty.rftoolsbuilder.RFToolsBuilder;
import mcjty.rftoolsbuilder.modules.shield.ShieldConfiguration;
import mcjty.rftoolsbuilder.modules.shield.blocks.ShieldProjectorBlock;
import mcjty.rftoolsbuilder.modules.shield.blocks.ShieldProjectorTileEntity;
import mcjty.rftoolsbuilder.modules.shield.blocks.ShieldTemplateBlock;
import mcjty.rftoolsbuilder.modules.shield.blocks.ShieldingBlock;
import mcjty.rftoolsbuilder.modules.shield.blocks.ShieldingTileEntity;
import net.minecraft.block.Block;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntityType;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;

public class ShieldSetup {
    public static final DeferredRegister<Item> ITEMS = new DeferredRegister(ForgeRegistries.ITEMS, "rftoolsbuilder");
    public static final DeferredRegister<Block> BLOCKS = new DeferredRegister(ForgeRegistries.BLOCKS, "rftoolsbuilder");
    public static final DeferredRegister<TileEntityType<?>> TILES = new DeferredRegister(ForgeRegistries.TILE_ENTITIES, "rftoolsbuilder");
    public static final DeferredRegister<ContainerType<?>> CONTAINERS = new DeferredRegister(ForgeRegistries.CONTAINERS, "rftoolsbuilder");
    public static final RegistryObject<BaseBlock> SHIELD_BLOCK1 = BLOCKS.register("shield_block1", () -> new ShieldProjectorBlock(ShieldSetup::createProjector1, (Integer)ShieldConfiguration.maxShieldSize.get()));
    public static final RegistryObject<BaseBlock> SHIELD_BLOCK2 = BLOCKS.register("shield_block2", () -> new ShieldProjectorBlock(ShieldSetup::createProjector2, (Integer)ShieldConfiguration.maxShieldSize.get() * 4));
    public static final RegistryObject<BaseBlock> SHIELD_BLOCK3 = BLOCKS.register("shield_block3", () -> new ShieldProjectorBlock(ShieldSetup::createProjector3, (Integer)ShieldConfiguration.maxShieldSize.get() * 16));
    public static final RegistryObject<BaseBlock> SHIELD_BLOCK4 = BLOCKS.register("shield_block4", () -> new ShieldProjectorBlock(ShieldSetup::createProjector4, (Integer)ShieldConfiguration.maxShieldSize.get() * 128));
    public static final RegistryObject<Item> SHIELD_BLOCK1_ITEM = ITEMS.register("shield_block1", () -> new BlockItem((Block)SHIELD_BLOCK1.get(), RFToolsBuilder.createStandardProperties()));
    public static final RegistryObject<Item> SHIELD_BLOCK2_ITEM = ITEMS.register("shield_block2", () -> new BlockItem((Block)SHIELD_BLOCK2.get(), RFToolsBuilder.createStandardProperties()));
    public static final RegistryObject<Item> SHIELD_BLOCK3_ITEM = ITEMS.register("shield_block3", () -> new BlockItem((Block)SHIELD_BLOCK3.get(), RFToolsBuilder.createStandardProperties()));
    public static final RegistryObject<Item> SHIELD_BLOCK4_ITEM = ITEMS.register("shield_block4", () -> new BlockItem((Block)SHIELD_BLOCK4.get(), RFToolsBuilder.createStandardProperties()));
    public static final RegistryObject<TileEntityType<?>> TYPE_SHIELD_BLOCK1 = TILES.register("shield_block1", () -> TileEntityType.Builder.func_223042_a(ShieldSetup::createProjector1, (Block[])new Block[]{(Block)SHIELD_BLOCK1.get()}).func_206865_a(null));
    public static final RegistryObject<TileEntityType<?>> TYPE_SHIELD_BLOCK2 = TILES.register("shield_block2", () -> TileEntityType.Builder.func_223042_a(ShieldSetup::createProjector2, (Block[])new Block[]{(Block)SHIELD_BLOCK2.get()}).func_206865_a(null));
    public static final RegistryObject<TileEntityType<?>> TYPE_SHIELD_BLOCK3 = TILES.register("shield_block3", () -> TileEntityType.Builder.func_223042_a(ShieldSetup::createProjector3, (Block[])new Block[]{(Block)SHIELD_BLOCK3.get()}).func_206865_a(null));
    public static final RegistryObject<TileEntityType<?>> TYPE_SHIELD_BLOCK4 = TILES.register("shield_block4", () -> TileEntityType.Builder.func_223042_a(ShieldSetup::createProjector4, (Block[])new Block[]{(Block)SHIELD_BLOCK4.get()}).func_206865_a(null));
    public static final RegistryObject<ContainerType<GenericContainer>> CONTAINER_SHIELD = CONTAINERS.register("shield", GenericContainer::createContainerType);
    public static final RegistryObject<ShieldTemplateBlock> TEMPLATE_BLUE = BLOCKS.register("blue_shield_template_block", () -> new ShieldTemplateBlock(ShieldTemplateBlock.TemplateColor.BLUE));
    public static final RegistryObject<ShieldTemplateBlock> TEMPLATE_RED = BLOCKS.register("red_shield_template_block", () -> new ShieldTemplateBlock(ShieldTemplateBlock.TemplateColor.RED));
    public static final RegistryObject<ShieldTemplateBlock> TEMPLATE_GREEN = BLOCKS.register("green_shield_template_block", () -> new ShieldTemplateBlock(ShieldTemplateBlock.TemplateColor.GREEN));
    public static final RegistryObject<ShieldTemplateBlock> TEMPLATE_YELLOW = BLOCKS.register("yellow_shield_template_block", () -> new ShieldTemplateBlock(ShieldTemplateBlock.TemplateColor.YELLOW));
    public static final RegistryObject<Item> TEMPLATE_BLUE_ITEM = ITEMS.register("blue_shield_template_block", () -> new BlockItem((Block)TEMPLATE_BLUE.get(), RFToolsBuilder.createStandardProperties()));
    public static final RegistryObject<Item> TEMPLATE_RED_ITEM = ITEMS.register("red_shield_template_block", () -> new BlockItem((Block)TEMPLATE_RED.get(), RFToolsBuilder.createStandardProperties()));
    public static final RegistryObject<Item> TEMPLATE_GREEN_ITEM = ITEMS.register("green_shield_template_block", () -> new BlockItem((Block)TEMPLATE_GREEN.get(), RFToolsBuilder.createStandardProperties()));
    public static final RegistryObject<Item> TEMPLATE_YELLOW_ITEM = ITEMS.register("yellow_shield_template_block", () -> new BlockItem((Block)TEMPLATE_YELLOW.get(), RFToolsBuilder.createStandardProperties()));
    public static final RegistryObject<ShieldingBlock> SHIELDING_SOLID = BLOCKS.register("shielding_solid", ShieldingBlock::new);
    public static final RegistryObject<ShieldingBlock> SHIELDING_TRANSLUCENT = BLOCKS.register("shielding_translucent", ShieldingBlock::new);
    public static final RegistryObject<ShieldingBlock> SHIELDING_CUTOUT = BLOCKS.register("shielding_cutout", ShieldingBlock::new);
    public static final RegistryObject<TileEntityType<?>> TYPE_SHIELDING = TILES.register("shielding", () -> TileEntityType.Builder.func_223042_a(ShieldingTileEntity::new, (Block[])new Block[]{(Block)SHIELDING_SOLID.get(), (Block)SHIELDING_TRANSLUCENT.get(), (Block)SHIELDING_CUTOUT.get()}).func_206865_a(null));

    public static void register() {
        BLOCKS.register(FMLJavaModLoadingContext.get().getModEventBus());
        ITEMS.register(FMLJavaModLoadingContext.get().getModEventBus());
        TILES.register(FMLJavaModLoadingContext.get().getModEventBus());
        CONTAINERS.register(FMLJavaModLoadingContext.get().getModEventBus());
    }

    public static ShieldProjectorTileEntity createProjector1() {
        return new ShieldProjectorTileEntity((TileEntityType)TYPE_SHIELD_BLOCK1.get(), (Integer)ShieldConfiguration.maxShieldSize.get(), (Integer)ShieldConfiguration.MAXENERGY.get(), (Integer)ShieldConfiguration.RECEIVEPERTICK.get());
    }

    public static ShieldProjectorTileEntity createProjector2() {
        return new ShieldProjectorTileEntity((TileEntityType)TYPE_SHIELD_BLOCK2.get(), (Integer)ShieldConfiguration.maxShieldSize.get() * 4, (Integer)ShieldConfiguration.MAXENERGY.get(), (Integer)ShieldConfiguration.RECEIVEPERTICK.get());
    }

    public static ShieldProjectorTileEntity createProjector3() {
        return new ShieldProjectorTileEntity((TileEntityType)TYPE_SHIELD_BLOCK3.get(), (Integer)ShieldConfiguration.maxShieldSize.get() * 16, (Integer)ShieldConfiguration.MAXENERGY.get() * 3, (Integer)ShieldConfiguration.RECEIVEPERTICK.get() * 2).setDamageFactor(4.0f).setCostFactor(2.0f);
    }

    public static ShieldProjectorTileEntity createProjector4() {
        return new ShieldProjectorTileEntity((TileEntityType)TYPE_SHIELD_BLOCK4.get(), (Integer)ShieldConfiguration.maxShieldSize.get() * 128, (Integer)ShieldConfiguration.MAXENERGY.get() * 6, (Integer)ShieldConfiguration.RECEIVEPERTICK.get() * 6).setDamageFactor(4.0f).setCostFactor(2.0f);
    }
}

