/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsbuilder.modules.scanner.network;

import java.util.function.Supplier;
import mcjty.lib.network.NetworkTools;
import mcjty.lib.varia.RLE;
import mcjty.rftoolsbuilder.modules.builder.BuilderSetup;
import mcjty.rftoolsbuilder.modules.builder.blocks.SupportBlock;
import mcjty.rftoolsbuilder.shapes.RenderData;
import mcjty.rftoolsbuilder.shapes.ShapeID;
import mcjty.rftoolsbuilder.shapes.ShapeRenderer;
import mcjty.rftoolsbuilder.shapes.StatePalette;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class PacketReturnShapeData {
    private ShapeID id;
    private RLE positions;
    private StatePalette statePalette;
    private int count;
    private int offsetY;
    private String msg;
    private BlockPos dimension;

    public void toBytes(PacketBuffer buf) {
        this.id.toBytes(buf);
        buf.writeInt(this.count);
        buf.writeInt(this.offsetY);
        NetworkTools.writeStringUTF8((PacketBuffer)buf, (String)this.msg);
        buf.func_179255_a(this.dimension);
        if (this.statePalette == null) {
            buf.writeInt(0);
        } else {
            buf.writeInt(this.statePalette.getPalette().size());
            for (BlockState state : this.statePalette.getPalette()) {
                if (state.func_177230_c().getRegistryName() == null) {
                    state = Blocks.field_150348_b.func_176223_P();
                }
                buf.func_180714_a(state.func_177230_c().getRegistryName().toString());
            }
        }
        if (this.positions == null) {
            buf.writeInt(0);
        } else {
            buf.writeInt(this.positions.getData().length);
            buf.writeBytes(this.positions.getData());
        }
    }

    public PacketReturnShapeData() {
    }

    public PacketReturnShapeData(PacketBuffer buf) {
        int size;
        this.id = new ShapeID(buf);
        this.count = buf.readInt();
        this.offsetY = buf.readInt();
        this.msg = NetworkTools.readStringUTF8((PacketBuffer)buf);
        this.dimension = buf.func_179259_c();
        if (size == 0) {
            this.statePalette = null;
        } else {
            this.statePalette = new StatePalette();
            for (size = buf.readInt(); size > 0; --size) {
                String r = buf.func_150789_c(Short.MAX_VALUE);
                Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(r));
                this.statePalette.add(block.func_176223_P());
            }
        }
        size = buf.readInt();
        if (size == 0) {
            this.positions = null;
        } else {
            this.positions = new RLE();
            byte[] data = new byte[size];
            buf.readBytes(data);
            this.positions.setData(data);
        }
    }

    public PacketReturnShapeData(ShapeID id, RLE positions, StatePalette statePalette, BlockPos dimension, int count, int offsetY, String msg) {
        this.id = id;
        this.positions = positions;
        this.statePalette = statePalette;
        this.dimension = dimension;
        this.count = count;
        this.offsetY = offsetY;
        this.msg = msg;
    }

    public void handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        ctx.enqueueWork(() -> {
            int dx = this.dimension.func_177958_n();
            int dy = this.dimension.func_177956_o();
            int dz = this.dimension.func_177952_p();
            RLE rle = this.positions;
            RenderData.RenderPlane plane = null;
            if (rle != null) {
                BlockState dummy = ((SupportBlock)BuilderSetup.SUPPORT.get()).func_176223_P();
                rle.reset();
                int oy = this.offsetY;
                int y = oy - dy / 2;
                RenderData.RenderStrip[] strips = new RenderData.RenderStrip[dx];
                for (int ox = 0; ox < dx; ++ox) {
                    RenderData.RenderStrip strip;
                    int x = ox - dx / 2;
                    strips[ox] = strip = new RenderData.RenderStrip(x);
                    for (int oz = 0; oz < dz; ++oz) {
                        int data = rle.read();
                        if (data < 255) {
                            if (data == 0) {
                                strip.add(dummy);
                                continue;
                            }
                            strip.add(this.statePalette.getPalette().get(--data));
                            continue;
                        }
                        strip.add(null);
                    }
                    strip.close();
                    plane = new RenderData.RenderPlane(strips, y, oy, -dz / 2, this.count);
                }
            }
            ShapeRenderer.setRenderData(this.id, plane, this.offsetY, dy, this.msg);
        });
        ctx.setPacketHandled(true);
    }
}

