/*
 * Decompiled with CFR 0.152.
 */
package net.telepathicgrunt.bumblezone.generation;

import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.fluid.FlowingFluid;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.chunk.ChunkSection;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.INoiseGenerator;
import net.minecraft.world.gen.OctavesNoiseGenerator;
import net.minecraft.world.gen.PerlinNoiseGenerator;
import net.minecraft.world.gen.WorldGenRegion;
import net.telepathicgrunt.bumblezone.Bumblezone;
import net.telepathicgrunt.bumblezone.blocks.BzBlocks;
import net.telepathicgrunt.bumblezone.modcompatibility.BuzzierBeesRedirection;
import net.telepathicgrunt.bumblezone.modcompatibility.ModChecking;

public abstract class BzNoiseChunkGenerator<T extends GenerationSettings>
extends ChunkGenerator<T> {
    private static final BlockState STONE = Blocks.field_150348_b.func_176223_P();
    private static final BlockState AIR = Blocks.field_150350_a.func_176223_P();
    private final int verticalNoiseGranularity;
    private final int horizontalNoiseGranularity;
    private final int noiseSizeX;
    private final int noiseSizeY;
    private final int noiseSizeZ;
    protected final SharedSeedRandom randomSeed;
    private final OctavesNoiseGenerator minNoise;
    private final OctavesNoiseGenerator maxNoise;
    private final OctavesNoiseGenerator mainNoise;
    private final INoiseGenerator surfaceDepthNoise;
    protected final BlockState defaultBlock;
    protected final BlockState defaultFluid;

    public BzNoiseChunkGenerator(IWorld world, BiomeProvider biomeProvider, int horizontalNoiseGranularityIn, int verticalNoiseGranularityIn, int maxHeight, T settings) {
        super(world, biomeProvider, settings);
        this.verticalNoiseGranularity = verticalNoiseGranularityIn;
        this.horizontalNoiseGranularity = horizontalNoiseGranularityIn;
        this.defaultBlock = STONE;
        this.defaultFluid = ((FlowingFluid)BzBlocks.SUGAR_WATER_FLUID.get()).func_207188_f().func_206883_i();
        this.noiseSizeX = 16 / this.horizontalNoiseGranularity;
        this.noiseSizeY = maxHeight / this.verticalNoiseGranularity;
        this.noiseSizeZ = 16 / this.horizontalNoiseGranularity;
        this.randomSeed = new SharedSeedRandom(this.field_222541_b);
        this.minNoise = new OctavesNoiseGenerator(this.randomSeed, 15, 0);
        this.maxNoise = new OctavesNoiseGenerator(this.randomSeed, 15, 0);
        this.mainNoise = new OctavesNoiseGenerator(this.randomSeed, 7, 0);
        this.surfaceDepthNoise = new PerlinNoiseGenerator(this.randomSeed, 3, 0);
    }

    protected abstract double[] getBiomeNoiseColumn(int var1, int var2);

    protected abstract double func_222545_a(double var1, double var3, int var5);

    protected abstract void fillNoiseColumn(double[] var1, int var2, int var3);

    private double internalSetupPerlinNoiseGenerators(int x, int y, int z, double getXCoordinateScale, double getZCoordinateScale, double getHeightScale, double getMainCoordinateScale, double getMainHeightScale, double p_222552_10_) {
        double d0 = 0.0;
        double d1 = 0.0;
        double d2 = 0.0;
        double d3 = 1.0;
        for (int i = 0; i < 16; ++i) {
            double limitX = OctavesNoiseGenerator.func_215461_a((double)((double)x * getXCoordinateScale * d3));
            double limitY = OctavesNoiseGenerator.func_215461_a((double)((double)y * getHeightScale * d3));
            double limitZ = OctavesNoiseGenerator.func_215461_a((double)((double)z * getZCoordinateScale * d3));
            double mainX = OctavesNoiseGenerator.func_215461_a((double)((double)x * getMainCoordinateScale * d3));
            double mainY = OctavesNoiseGenerator.func_215461_a((double)((double)y * getMainHeightScale * d3));
            double mainZ = OctavesNoiseGenerator.func_215461_a((double)((double)z * getMainCoordinateScale * d3));
            double d7 = getHeightScale * d3;
            d0 += this.minNoise.func_215463_a(i).func_215456_a(limitX, limitY, limitZ, d7, (double)y * d7) / d3;
            d1 += this.maxNoise.func_215463_a(i).func_215456_a(limitX, limitY, limitZ, d7, (double)y * d7) / d3;
            if (i < 8) {
                d2 += this.mainNoise.func_215463_a(i).func_215456_a(mainX, mainY, mainZ, p_222552_10_ * d3, (double)y * p_222552_10_ * d3) / d3;
            }
            d3 /= 2.0;
        }
        return MathHelper.func_151238_b((double)(d0 / 512.0), (double)(d1 / 512.0), (double)((d2 / 10.0 + 1.0) / 2.0));
    }

    protected double[] func_222547_b(int p_222547_1_, int p_222547_2_) {
        double[] adouble = new double[this.noiseSizeY + 1];
        this.fillNoiseColumn(adouble, p_222547_1_, p_222547_2_);
        return adouble;
    }

    protected void setupPerlinNoiseGenerators(double[] areaArrayIn, int x, int z, double getXCoordinateScale, double getZCoordinateScale, double getHeightScale, double getMainCoordinateScale, double getMainHeightScale, double p_222546_10_, int p_222546_12_, int p_222546_13_) {
        double[] localAreaArray = this.getBiomeNoiseColumn(x, z);
        double d0 = localAreaArray[0];
        double d1 = localAreaArray[1];
        double d2 = this.noiseSizeY - 3;
        double d3 = 0.0;
        for (int y = 0; y < this.noiseSizeY + 1; ++y) {
            double d4 = this.internalSetupPerlinNoiseGenerators(x, y, z, getXCoordinateScale, getZCoordinateScale, getHeightScale, getMainCoordinateScale, getMainHeightScale, p_222546_10_);
            d4 -= this.func_222545_a(d0, d1, y);
            if ((double)y > d2) {
                d4 = MathHelper.func_151238_b((double)d4, (double)p_222546_13_, (double)(((double)y - d2) / (double)p_222546_12_));
            } else if ((double)y < d3) {
                d4 = MathHelper.func_151238_b((double)d4, (double)-30.0, (double)((d3 - (double)y) / (d3 - 1.0)));
            }
            areaArrayIn[y] = d4;
        }
    }

    public int func_222529_a(int chunkX, int chunkZ, Heightmap.Type heightmapType) {
        int minX = Math.floorDiv(chunkX, this.horizontalNoiseGranularity);
        int minZ = Math.floorDiv(chunkZ, this.horizontalNoiseGranularity);
        int modX = Math.floorMod(chunkX, this.horizontalNoiseGranularity);
        int modZ = Math.floorMod(chunkZ, this.horizontalNoiseGranularity);
        double xFactor = (double)modX / (double)this.horizontalNoiseGranularity;
        double zFactor = (double)modZ / (double)this.horizontalNoiseGranularity;
        double[][] terrain2DArray = new double[][]{this.func_222547_b(minX, minZ), this.func_222547_b(minX, minZ + 1), this.func_222547_b(minX + 1, minZ), this.func_222547_b(minX + 1, minZ + 1)};
        for (int noiseY = this.noiseSizeY - 1; noiseY >= 0; --noiseY) {
            double d2 = terrain2DArray[0][noiseY];
            double d3 = terrain2DArray[1][noiseY];
            double d4 = terrain2DArray[2][noiseY];
            double d5 = terrain2DArray[3][noiseY];
            double d6 = terrain2DArray[0][noiseY + 1];
            double d7 = terrain2DArray[1][noiseY + 1];
            double d8 = terrain2DArray[2][noiseY + 1];
            double d9 = terrain2DArray[3][noiseY + 1];
            for (int yOffset = this.verticalNoiseGranularity - 1; yOffset >= 0; --yOffset) {
                double yFactor = (double)yOffset / (double)this.verticalNoiseGranularity;
                double finalNoise = MathHelper.func_219807_a((double)yFactor, (double)xFactor, (double)zFactor, (double)d2, (double)d6, (double)d4, (double)d8, (double)d3, (double)d7, (double)d5, (double)d9);
                int y = noiseY * this.verticalNoiseGranularity + yOffset;
                if (!(finalNoise > 0.0)) continue;
                BlockState blockstate = finalNoise > 0.0 ? this.defaultBlock : this.defaultFluid;
                if (!heightmapType.func_222684_d().test(blockstate)) continue;
                return y + 1;
            }
        }
        return 0;
    }

    public void func_225551_a_(WorldGenRegion region, IChunk chunk) {
        ChunkPos chunkpos = chunk.func_76632_l();
        int i = chunkpos.field_77276_a;
        int j = chunkpos.field_77275_b;
        SharedSeedRandom sharedseedrandom = new SharedSeedRandom();
        sharedseedrandom.func_202422_a(i, j);
        ChunkPos chunkpos1 = chunk.func_76632_l();
        int chunkX = chunkpos1.func_180334_c();
        int chunkZ = chunkpos1.func_180333_d();
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int xPos = chunkX + x;
                int zPos = chunkZ + z;
                int ySurface = chunk.func_201576_a(Heightmap.Type.WORLD_SURFACE_WG, x, z) + 1;
                double noise = this.surfaceDepthNoise.func_215460_a((double)xPos * 0.0625, (double)zPos * 0.0625, 0.0625, (double)x * 0.0625) * 10.0;
                region.func_226691_t_((BlockPos)blockpos$mutable.func_181079_c(chunkX + x, ySurface, chunkZ + z)).func_206854_a((Random)sharedseedrandom, chunk, xPos, zPos, ySurface, noise, this.defaultBlock, this.defaultFluid, region.func_181545_F(), this.field_222540_a.func_72905_C());
            }
        }
        this.makeBedrock(chunk, (Random)sharedseedrandom);
    }

    protected void makeBedrock(IChunk chunk, Random random) {
        if (ModChecking.buzzierBeesPresent && Bumblezone.BzConfig.hivePlanksWorldgen.get().booleanValue()) {
            BuzzierBeesRedirection.makeBedrock(chunk, random);
        } else {
            BlockPos.Mutable blockpos$Mutable = new BlockPos.Mutable();
            int xStart = chunk.func_76632_l().func_180334_c();
            int zStart = chunk.func_76632_l().func_180333_d();
            int roofHeight = 255;
            int floorHeight = 0;
            for (BlockPos blockpos : BlockPos.func_191531_b((int)xStart, (int)0, (int)zStart, (int)(xStart + 15), (int)0, (int)(zStart + 15))) {
                for (int ceilingY = roofHeight; ceilingY >= roofHeight - 7; --ceilingY) {
                    chunk.func_177436_a((BlockPos)blockpos$Mutable.func_181079_c(blockpos.func_177958_n(), ceilingY, blockpos.func_177952_p()), Blocks.field_226908_md_.func_176223_P(), false);
                }
                for (int floorY = floorHeight; floorY <= floorHeight; ++floorY) {
                    chunk.func_177436_a((BlockPos)blockpos$Mutable.func_181079_c(blockpos.func_177958_n(), floorY, blockpos.func_177952_p()), Blocks.field_226908_md_.func_176223_P(), false);
                }
            }
        }
    }

    public void func_222537_b(IWorld world, IChunk chunk) {
        ChunkPos chunkpos = chunk.func_76632_l();
        int chunkX = chunkpos.field_77276_a;
        int chunkZ = chunkpos.field_77275_b;
        int coordinateX = chunkX << 4;
        int coordinateZ = chunkZ << 4;
        double[][][] terrainNoise2DArray = new double[2][this.noiseSizeZ + 1][this.noiseSizeY + 1];
        for (int index = 0; index < this.noiseSizeZ + 1; ++index) {
            terrainNoise2DArray[0][index] = new double[this.noiseSizeY + 1];
            this.fillNoiseColumn(terrainNoise2DArray[0][index], chunkX * this.noiseSizeX, chunkZ * this.noiseSizeZ + index);
            terrainNoise2DArray[1][index] = new double[this.noiseSizeY + 1];
        }
        ChunkPrimer chunkprimer = (ChunkPrimer)chunk;
        Heightmap heightmap = chunkprimer.func_217303_b(Heightmap.Type.OCEAN_FLOOR_WG);
        Heightmap heightmap1 = chunkprimer.func_217303_b(Heightmap.Type.WORLD_SURFACE_WG);
        BlockPos.Mutable blockpos$Mutable = new BlockPos.Mutable();
        for (int xNoise = 0; xNoise < this.noiseSizeX; ++xNoise) {
            int zNoise;
            for (zNoise = 0; zNoise < this.noiseSizeZ + 1; ++zNoise) {
                this.fillNoiseColumn(terrainNoise2DArray[1][zNoise], chunkX * this.noiseSizeX + xNoise + 1, chunkZ * this.noiseSizeZ + zNoise);
            }
            for (zNoise = 0; zNoise < this.noiseSizeZ; ++zNoise) {
                ChunkSection chunksection = chunkprimer.func_217332_a(15);
                chunksection.func_222635_a();
                for (int yNoise = this.noiseSizeY - 1; yNoise >= 0; --yNoise) {
                    double d4;
                    double d3;
                    double d2;
                    double d1;
                    double d0;
                    double d18;
                    double d17;
                    double d16;
                    int yNoiseMod;
                    int yChunk;
                    if (yNoise > 16) {
                        yChunk = yNoise - 1;
                        yNoiseMod = 31 - yChunk;
                        d16 = terrainNoise2DArray[0][zNoise][yNoiseMod + 1];
                        d17 = terrainNoise2DArray[0][zNoise + 1][yNoiseMod + 1];
                        d18 = terrainNoise2DArray[1][zNoise][yNoiseMod + 1];
                        d0 = terrainNoise2DArray[1][zNoise + 1][yNoiseMod + 1];
                        d1 = terrainNoise2DArray[0][zNoise][yNoiseMod];
                        d2 = terrainNoise2DArray[0][zNoise + 1][yNoiseMod];
                        d3 = terrainNoise2DArray[1][zNoise][yNoiseMod];
                        d4 = terrainNoise2DArray[1][zNoise + 1][yNoiseMod];
                    } else {
                        yNoiseMod = yChunk = yNoise;
                        d16 = terrainNoise2DArray[0][zNoise][yNoiseMod];
                        d17 = terrainNoise2DArray[0][zNoise + 1][yNoiseMod];
                        d18 = terrainNoise2DArray[1][zNoise][yNoiseMod];
                        d0 = terrainNoise2DArray[1][zNoise + 1][yNoiseMod];
                        d1 = terrainNoise2DArray[0][zNoise][yNoiseMod + 1];
                        d2 = terrainNoise2DArray[0][zNoise + 1][yNoiseMod + 1];
                        d3 = terrainNoise2DArray[1][zNoise][yNoiseMod + 1];
                        d4 = terrainNoise2DArray[1][zNoise + 1][yNoiseMod + 1];
                    }
                    for (int yInfluence = this.verticalNoiseGranularity - 1; yInfluence >= 0; --yInfluence) {
                        int currentY = yChunk * this.verticalNoiseGranularity + yInfluence;
                        int y = currentY & 0xF;
                        int yChunkFinal = currentY >> 4;
                        if (chunksection.func_222632_g() >> 4 != yChunkFinal) {
                            chunksection.func_222637_b();
                            chunksection = chunkprimer.func_217332_a(yChunkFinal);
                            chunksection.func_222635_a();
                        }
                        double d5 = (double)yInfluence / (double)this.verticalNoiseGranularity;
                        double d6 = MathHelper.func_219803_d((double)d5, (double)d16, (double)d1);
                        double d7 = MathHelper.func_219803_d((double)d5, (double)d18, (double)d3);
                        double d8 = MathHelper.func_219803_d((double)d5, (double)d17, (double)d2);
                        double d9 = MathHelper.func_219803_d((double)d5, (double)d0, (double)d4);
                        for (int horizontalNoiseX = 0; horizontalNoiseX < this.horizontalNoiseGranularity; ++horizontalNoiseX) {
                            int xCoordinate = coordinateX + xNoise * this.horizontalNoiseGranularity + horizontalNoiseX;
                            int xInChunk = xCoordinate & 0xF;
                            double d10 = (double)horizontalNoiseX / (double)this.horizontalNoiseGranularity;
                            double d11 = MathHelper.func_219803_d((double)d10, (double)d6, (double)d7);
                            double d12 = MathHelper.func_219803_d((double)d10, (double)d8, (double)d9);
                            for (int horizontalNoiseZ = 0; horizontalNoiseZ < this.horizontalNoiseGranularity; ++horizontalNoiseZ) {
                                int zCoordinate = coordinateZ + zNoise * this.horizontalNoiseGranularity + horizontalNoiseZ;
                                int zInChunk = zCoordinate & 0xF;
                                double d13 = (double)horizontalNoiseZ / (double)this.horizontalNoiseGranularity;
                                double d14 = MathHelper.func_219803_d((double)d13, (double)d11, (double)d12);
                                double finalTerrainNoise = MathHelper.func_151237_a((double)(d14 / 200.0), (double)-1.0, (double)1.0);
                                BlockState blockstate = finalTerrainNoise > 0.0 ? this.defaultBlock : (currentY < this.func_222530_f() ? this.defaultFluid : AIR);
                                if (blockstate == AIR) continue;
                                if (blockstate.func_185906_d() != 0) {
                                    blockpos$Mutable.func_181079_c(xCoordinate, currentY, zCoordinate);
                                    chunkprimer.func_201637_h((BlockPos)blockpos$Mutable);
                                }
                                chunksection.func_177484_a(xInChunk, y, zInChunk, blockstate, false);
                                heightmap.func_202270_a(xInChunk, currentY, zInChunk, blockstate);
                                heightmap1.func_202270_a(xInChunk, currentY, zInChunk, blockstate);
                            }
                        }
                    }
                }
                chunksection.func_222637_b();
            }
            double[][] adouble1 = terrainNoise2DArray[0];
            terrainNoise2DArray[0] = terrainNoise2DArray[1];
            terrainNoise2DArray[1] = adouble1;
        }
    }
}

